package vctemplate

import (
	"chainmaker.org/chainmaker/opennet/servicecommon/res"
	"net/http"

	"cnbn-did/internal/logic/vctemplate"
	"cnbn-did/internal/svc"
	"cnbn-did/internal/types"
	"github.com/zeromicro/go-zero/rest/httpx"
)

func OnequeryvctemplateHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.VcTemplateId
		if err := httpx.Parse(r, &req); err != nil {
			httpx.OkJsonCtx(r.Context(), w, res.ParameterError.AddError(err).AddMessage("OnequeryvctemplateHandler").BuildRESTful())
			return
		}

		l := vctemplate.NewOnequeryvctemplateLogic(r.Context(), svcCtx)
		resp, err := l.Onequeryvctemplate(&req)
		if err != nil {
			httpx.OkJsonCtx(r.Context(), w, res.ServiceError.AddError(err).AddMessage("OnequeryvctemplateHandler").BuildRESTful())
			return
		} else {
			httpx.OkJson(w, resp)
		}
	}
}
