package vctemplate

import (
	"chainmaker.org/chainmaker/opennet/servicecommon/res"
	"encoding/json"
	"io"
	"net/http"

	"cnbn-did/internal/logic/vctemplate"
	"cnbn-did/internal/svc"
	"cnbn-did/internal/types"
	"github.com/zeromicro/go-zero/rest/httpx"
)

func PagequeryvctemplateHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.VcTemplatePageRequest
		bytes, err := io.ReadAll(r.Body)
		if err != nil {
			httpx.OkJsonCtx(r.Context(), w, res.ParameterError.AddError(err).AddMessage("PagequeryvctemplateHandler读取Body失败").BuildRESTful())
			return
		}
		if err := json.Unmarshal(bytes, &req); err != nil {
			httpx.OkJsonCtx(r.Context(), w, res.ParameterError.AddError(err).AddMessage("PagequeryvctemplateHandler Unmarshal失败").BuildRESTful())
			return
		}

		l := vctemplate.NewPagequeryvctemplateLogic(r.Context(), svcCtx)
		resp, err := l.Pagequeryvctemplate(&req)
		if err != nil {
			httpx.OkJsonCtx(r.Context(), w, res.ServiceError.AddError(err).AddMessage("PagequeryvctemplateHandler").BuildRESTful())
			return
		} else {
			httpx.OkJson(w, resp)
		}
	}
}
