/*
Copyright (C) BABEC. All rights reserved.

SPDX-License-Identifier: Apache-2.0
*/

package vctemplate

import (
	"chainmaker.org/chainmaker/opennet/servicecommon/res"
	"encoding/json"
	"io"
	"net/http"

	"cnbn-did/internal/logic/vctemplate"
	"cnbn-did/internal/svc"
	"cnbn-did/internal/types"

	"github.com/zeromicro/go-zero/rest/httpx"
)

func UpgradevctemplatevpHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.VerifiablePresentation
		bytes, err := io.ReadAll(r.Body)
		if err != nil {
			httpx.OkJsonCtx(r.Context(), w, res.ParameterError.AddError(err).AddMessage("UpgradevctemplatevpHandler读取Body失败").BuildRESTful())
			return
		}
		if err := json.Unmarshal(bytes, &req); err != nil {
			httpx.OkJsonCtx(r.Context(), w, res.ParameterError.AddError(err).AddMessage("UpgradevctemplatevpHandler Unmarshal失败").BuildRESTful())
			return
		}

		l := vctemplate.NewUpgradevctemplatevpLogic(r.Context(), svcCtx)
		resp, err := l.Upgradevctemplatevp(&req)
		if err != nil {
			httpx.ErrorCtx(r.Context(), w, err)
		} else {
			httpx.OkJsonCtx(r.Context(), w, resp)
		}
	}
}
