/*
Copyright (C) BABEC. All rights reserved.

SPDX-License-Identifier: Apache-2.0
*/

package verify

import (
	"chainmaker.org/chainmaker/opennet/servicecommon/res"
	"encoding/json"
	"io"
	"net/http"

	"cnbn-did/internal/logic/verify"
	"cnbn-did/internal/svc"
	"cnbn-did/internal/types"

	"github.com/zeromicro/go-zero/rest/httpx"
)

func VerifyVpHandler(svcCtx *svc.ServiceContext) http.HandlerFunc {
	return func(w http.ResponseWriter, r *http.Request) {
		var req types.VerifiablePresentation
		bytes, err := io.ReadAll(r.Body)
		if err != nil {
			httpx.OkJsonCtx(r.Context(), w, res.ParameterError.AddError(err).AddMessage("VerifyVpHandler读取Body失败").BuildRESTful())
			return
		}

		err = json.Unmarshal(bytes, &req)
		if err != nil {
			httpx.OkJsonCtx(r.Context(), w, res.ParameterError.AddError(err).AddMessage("VerifyVpHandler Unmarshal失败").BuildRESTful())
			return
		}

		l := verify.NewVerifyVpLogic(r.Context(), svcCtx)
		resp, err := l.VerifyVp(&req)
		if err != nil {
			httpx.OkJsonCtx(r.Context(), w, res.ServiceError.AddError(err).AddMessage("VerifyVpHandler").BuildRESTful())
			return
		} else {
			httpx.OkJsonCtx(r.Context(), w, resp)
		}
	}
}
