/*
Copyright (C) BABEC. All rights reserved.

SPDX-License-Identifier: Apache-2.0
*/

package blacklist

import (
	vo "chainmaker.org/chainmaker/opennet/did/vo/did"
	"chainmaker.org/chainmaker/opennet/servicecommon/copier"
	"chainmaker.org/chainmaker/opennet/servicecommon/res"
	"chainmaker.org/chainmaker/opennet/servicecommon/res/code"
	"cnbn-did/errorcode"
	"cnbn-did/internal/svc"
	"cnbn-did/internal/types"
	"context"

	"github.com/zeromicro/go-zero/core/logx"
)

type CheckLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewCheckLogic(ctx context.Context, svcCtx *svc.ServiceContext) *CheckLogic {
	return &CheckLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *CheckLogic) Check(req *types.CheckRequest) (resp *types.CheckResponse, err error) {
	checkReq := &vo.CheckBlackListRequest{}
	resp = &types.CheckResponse{}
	err = copier.Copy(&req, &checkReq)
	if err != nil {
		errorcode.InputException.AddError(err).AddMessage("CheckBlackList").BuildResult(resp)
		return resp, nil
	}
	result, err := l.svcCtx.BlackListService.CheckBlackList(l.ctx, checkReq)
	if err != nil {
		errorcode.CommonCallServiceFailed.AddError(err).AddMessage("CheckBlackList").BuildResult(resp)
		return resp, nil
	}

	resp = new(types.CheckResponse)
	if code.CodeOk.EqualsInt32(result.Code) {
		err = copier.Copy(&result, &resp)
		if err != nil {
			errorcode.ServiceResultException.AddError(err).AddMessage("Createvctemplate").BuildResult(resp)
			return resp, nil
		}
		return resp, nil

	} else {
		res.ErrorMessageCode(code.Code(result.Code), result.Msg).AddMessage("Createvctemplate code is not 200000").BuildResult(resp)
		return resp, nil
	}

	return
}
