/*
Copyright (C) BABEC. All rights reserved.

SPDX-License-Identifier: Apache-2.0
*/

package document

import (
	"chainmaker.org/chainmaker/opennet/did/vo/did"
	"chainmaker.org/chainmaker/opennet/servicecommon/copier"
	"cnbn-did/errorcode"
	"context"

	"cnbn-did/internal/svc"
	"cnbn-did/internal/types"

	"github.com/zeromicro/go-zero/core/logx"
)

type GetDocumentByAddressLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewGetDocumentByAddressLogic(ctx context.Context, svcCtx *svc.ServiceContext) *GetDocumentByAddressLogic {
	return &GetDocumentByAddressLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *GetDocumentByAddressLogic) GetDocumentByAddress(req *types.DocumentGetByAddressRequest) (resp *types.DocumentResponse, err error) {
	in := &did.DocumentGetByAddressRequest{}
	resp = &types.DocumentResponse{}

	err = copier.Copy(req, in)
	if err != nil {
		errorcode.CommonRequestCopyFailed.AddError(err).AddMessage("get document by address").BuildResult(resp)
		return resp, nil
	}

	out, err := l.svcCtx.DocumentService.GetDocumentByAddress(l.ctx, in)
	if err != nil {
		errorcode.CommonCallServiceFailed.AddError(err).AddMessage("get document by address").BuildResult(resp)
		return resp, nil
	}

	err = copier.Copy(out, resp)
	if err != nil {
		errorcode.CommonRequestCopyFailed.AddError(err).AddMessage("get document by address response").BuildResult(resp)
		return resp, nil
	}

	return resp, nil
}
