/*
Copyright (C) BABEC. All rights reserved.

SPDX-License-Identifier: Apache-2.0
*/

package document

import (
	"chainmaker.org/chainmaker/opennet/did/vo/did"
	"chainmaker.org/chainmaker/opennet/servicecommon/copier"
	"cnbn-did/errorcode"
	"cnbn-did/internal/svc"
	"cnbn-did/internal/types"
	"context"

	"github.com/zeromicro/go-zero/core/logx"
)

type GetDocumentLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewGetDocumentLogic(ctx context.Context, svcCtx *svc.ServiceContext) *GetDocumentLogic {
	return &GetDocumentLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *GetDocumentLogic) GetDocument(req *types.DocumentGetRequest) (resp *types.DocumentResponse, err error) {
	resp = &types.DocumentResponse{}
	in := &did.DocumentGetRequest{}

	err = copier.Copy(req, in)
	if err != nil {
		errorcode.CommonRequestCopyFailed.AddError(err).AddMessage("GetDocument").BuildResult(resp)
		return resp, nil
	}
	document, err := l.svcCtx.DocumentService.GetDocument(l.ctx, in)
	if err != nil {
		errorcode.CommonCallServiceFailed.AddError(err).AddMessage("GetDocument").BuildResult(resp)
		return resp, nil
	}
	err = copier.Copy(document, resp)
	if err != nil {
		errorcode.CommonResponseCopyFailed.AddError(err).AddMessage("get document response").BuildResult(resp)
	}
	return
}
