/*
Copyright (C) BABEC. All rights reserved.

SPDX-License-Identifier: Apache-2.0
*/

package document

import (
	"chainmaker.org/chainmaker/opennet/did/vo/did"
	"chainmaker.org/chainmaker/opennet/servicecommon/copier"
	"chainmaker.org/chainmaker/opennet/servicecommon/res"
	"chainmaker.org/chainmaker/opennet/servicecommon/res/code"
	"cnbn-did/errorcode"
	"cnbn-did/internal/svc"
	"cnbn-did/internal/types"
	"context"
	"github.com/zeromicro/go-zero/core/logx"
)

type GetListDocumentLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewGetListDocumentLogic(ctx context.Context, svcCtx *svc.ServiceContext) *GetListDocumentLogic {
	return &GetListDocumentLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *GetListDocumentLogic) GetListDocument(req *types.DocumentGetListRequest) (resp *types.DocumentListResponse, err error) {
	resp = &types.DocumentListResponse{}
	in := &did.DocumentGetListRequest{}

	err = copier.Copy(req, in)
	if err != nil {
		errorcode.CommonRequestCopyFailed.AddError(err).AddMessage("GetListDocument").BuildResult(resp)
		return resp, nil
	}
	document, err := l.svcCtx.DocumentService.GetListDocument(l.ctx, in)
	if err != nil {
		errorcode.CommonCallServiceFailed.AddError(err).AddMessage("GetListDocument").BuildResult(resp)
		return resp, nil
	}
	if code.CodeOk.NotEqualsInt32(document.Code) {
		res.ErrorMessageCode(code.Code(document.Code), document.Msg).BuildResult(resp)
		return resp, nil
	}

	err = copier.Copy(document, &resp)
	if err != nil {
		errorcode.CommonRequestCopyFailed.AddError(err).AddMessage("GetListDocument").BuildResult(resp)
		return resp, nil
	}

	return resp, nil
}
