/*
Copyright (C) BABEC. All rights reserved.

SPDX-License-Identifier: Apache-2.0
*/

package document

import (
	"chainmaker.org/chainmaker/opennet/did/vo/did"
	"chainmaker.org/chainmaker/opennet/servicecommon/copier"
	"chainmaker.org/chainmaker/opennet/servicecommon/res"
	"cnbn-did/errorcode"
	"context"

	"cnbn-did/internal/svc"
	"cnbn-did/internal/types"

	"github.com/zeromicro/go-zero/core/logx"
)

type ImportDocumentLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewImportDocumentLogic(ctx context.Context, svcCtx *svc.ServiceContext) *ImportDocumentLogic {
	return &ImportDocumentLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (s *ImportDocumentLogic) ImportDocument(req *types.DocumentImportRequest) (resp *types.DocumentResponse, err error) {
	in := &did.DocumentImportRequest{}
	resp = &types.DocumentResponse{}
	if req.Password != "8u48934978897" {
		res.ServiceError.AddMessage("wrong password").BuildResult(resp)
		return resp, nil
	}
	err = copier.Copy(req, in)
	if err != nil {
		errorcode.CommonRequestCopyFailed.AddError(err).AddMessage("import document").BuildResult(resp)
		return resp, nil
	}
	response, err := s.svcCtx.DocumentService.Import(s.ctx, in)
	if err != nil {
		errorcode.CommonCallServiceFailed.AddError(err).AddMessage("import document").BuildResult(resp)
		return resp, nil
	}
	err = copier.Copy(response, resp)
	if err != nil {
		errorcode.CommonResponseCopyFailed.AddError(err).AddMessage("import document").BuildResult(resp)
		return resp, nil
	}
	return
}
