/*
Copyright (C) BABEC. All rights reserved.

SPDX-License-Identifier: Apache-2.0
*/

package document

import (
	vo "chainmaker.org/chainmaker/opennet/did/vo/did"
	"chainmaker.org/chainmaker/opennet/servicecommon/copier"
	"chainmaker.org/chainmaker/opennet/servicecommon/res"
	"chainmaker.org/chainmaker/opennet/servicecommon/res/code"
	"cnbn-did/errorcode"
	"cnbn-did/internal/svc"
	"cnbn-did/internal/types"
	"context"
	"github.com/zeromicro/go-zero/core/logx"
)

type UpdateDocumentLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewUpdateDocumentLogic(ctx context.Context, svcCtx *svc.ServiceContext) *UpdateDocumentLogic {
	return &UpdateDocumentLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *UpdateDocumentLogic) UpdateDocument(req *types.DocumentUpdateRequest) (resp *types.DocumentResponse, err error) {
	// todo: add your logic here and delete this line
	resp = &types.DocumentResponse{}
	var voreq vo.DocumentUpdateRequest
	err = copier.Copy(req, &voreq)
	if err != nil {
		errorcode.InputException.AddError(err).AddMessage("UpdateDocument").BuildResult(resp)
		return resp, nil
	}
	result, err := l.svcCtx.DocumentService.UpdateDocument(l.ctx, &voreq)
	if err != nil {
		errorcode.CommonCallServiceFailed.AddError(err).AddMessage("UpdateDocument").BuildResult(resp)
		return resp, nil
	}
	if code.CodeOk.NotEqualsInt32(result.Code) {
		res.ErrorMessageCode(code.Code(result.Code), result.Msg).AddMessage("UpdateDocument code is not 200000").BuildResult(resp)
		return resp, nil
	}
	err = copier.Copy(result.Data.Document, &resp.Data.Document)
	if err != nil {
		errorcode.CommonUnmarshalException.AddError(err).AddMessage("UpdateDocument").BuildResult(resp)
		return resp, nil
	}
	res.OK.BuildResult(resp)
	return resp, nil
}
