/*
Copyright (C) BABEC. All rights reserved.

SPDX-License-Identifier: Apache-2.0
*/

package generate

import (
	vo "chainmaker.org/chainmaker/opennet/did/vo/did"
	"chainmaker.org/chainmaker/opennet/servicecommon/copier"
	"cnbn-did/errorcode"
	"context"

	"cnbn-did/internal/svc"
	"cnbn-did/internal/types"

	"github.com/zeromicro/go-zero/core/logx"
)

type DocumentRegisterLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewDocumentRegisterLogic(ctx context.Context, svcCtx *svc.ServiceContext) *DocumentRegisterLogic {
	return &DocumentRegisterLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *DocumentRegisterLogic) DocumentRegister(req *types.GenDocumentRegisterRequest) (*types.GenDocumentRegisterResponse, error) {
	in := &vo.GenRegisterDocumentRequest{}
	resp := &types.GenDocumentRegisterResponse{}
	err := copier.Copy(req, in)
	if err != nil {
		errorcode.CommonRequestCopyFailed.AddMessage("GenRegisterDocumentRequest").AddError(err).BuildResult(resp)
		return resp, nil
	}

	document, err := l.svcCtx.GenerateService.RegisterDocument(l.ctx, in)
	if err != nil {
		errorcode.CommonCallServiceFailed.AddError(err).BuildResult(resp)
		return resp, nil
	}
	err = copier.Copy(document, resp)
	if err != nil {
		errorcode.CommonResponseCopyFailed.AddMessage("GenDocumentRegisterResponse").AddError(err).BuildResult(resp)
		return resp, nil
	}
	return resp, nil
}
