/*
Copyright (C) BABEC. All rights reserved.

SPDX-License-Identifier: Apache-2.0
*/

package generate

import (
	vo "chainmaker.org/chainmaker/opennet/did/vo/did"
	"chainmaker.org/chainmaker/opennet/servicecommon/res"
	"chainmaker.org/chainmaker/opennet/servicecommon/res/code"
	"cnbn-did/errorcode"
	"cnbn-did/internal/svc"
	"cnbn-did/internal/types"
	"context"
	"encoding/json"

	"github.com/zeromicro/go-zero/core/logx"
)

type GenCnbnVpLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewGenCnbnVpLogic(ctx context.Context, svcCtx *svc.ServiceContext) *GenCnbnVpLogic {
	return &GenCnbnVpLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *GenCnbnVpLogic) GenCnbnVp(req *types.GenVerifyVPRequest) (resp *types.GenCnbnVpResponse, err error) {
	resp = &types.GenCnbnVpResponse{}
	extend, err := json.Marshal(req.Extend)
	if err != nil {
		errorcode.CommonMarshalException.AddError(err).AddMessage("Extend").BuildResult(resp)
		return resp, nil
	}
	vp, err := l.svcCtx.GenerateService.VerifyVP(l.ctx, &vo.GenVerifyVPRequest{
		Did:    "did:cndid:cndid",
		Extend: extend,
	})
	if err != nil {
		errorcode.CommonCallServiceFailed.AddError(err).AddMessage("VerifyVP").BuildResult(resp)
		return resp, nil
	}
	if code.CodeOk.NotEqualsInt32(vp.Code) {
		res.ErrorMessageCode(code.Code(vp.Code), vp.Msg).AddMessage("VerifyVP code is not 200000").BuildResult(resp)
		return resp, nil
	}

	var Vp types.VerifiablePresentation
	err = json.Unmarshal(vp.Data.Plaintext.Plaintext, &Vp)
	if err != nil {
		errorcode.CommonUnmarshalException.AddError(err).AddMessage("VerifiablePresentation").BuildResult(resp)
		return resp, nil
	}
	resp.Code = vp.Code
	resp.Msg = vp.Msg
	resp.Data.Vp = Vp
	return
}
