/*
Copyright (C) BABEC. All rights reserved.

SPDX-License-Identifier: Apache-2.0
*/

package generate

import (
	vo "chainmaker.org/chainmaker/opennet/did/vo/did"
	"chainmaker.org/chainmaker/opennet/servicecommon/copier"
	"cnbn-did/errorcode"
	"context"

	"cnbn-did/internal/svc"
	"cnbn-did/internal/types"

	"github.com/zeromicro/go-zero/core/logx"
)

type UpdateDocumentServiceLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewUpdateDocumentServiceLogic(ctx context.Context, svcCtx *svc.ServiceContext) *UpdateDocumentServiceLogic {
	return &UpdateDocumentServiceLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *UpdateDocumentServiceLogic) UpdateDocumentService(req *types.GenUpdateDocumentServiceRequest) (resp *types.GenUpdateDocumentResponse, err error) {
	resp = &types.GenUpdateDocumentResponse{}
	voreq := &vo.UpdateDocumentServiceRequest{}
	err = copier.Copy(req, voreq)
	if err != nil {
		errorcode.InputException.AddError(err).AddMessage("UpdateDocumentVerificationMethod").BuildResult(resp)
		return resp, nil
	}
	result, err := l.svcCtx.GenerateService.UpdateDocumentService(l.ctx, voreq)
	if err != nil {
		errorcode.CommonCallServiceFailed.AddError(err).AddMessage("UpdateDocumentVerificationMethod").BuildResult(resp)
		return resp, nil
	}

	err = copier.Copy(result, resp)
	if err != nil {
		errorcode.ServiceResultException.AddError(err).AddMessage("UpdateDocumentVerificationMethod").BuildResult(resp)
		return resp, nil
	}

	return
}
