/*
Copyright (C) BABEC. All rights reserved.

SPDX-License-Identifier: Apache-2.0
*/

package inner

import (
	"chainmaker.org/chainmaker/opennet/did/vo/did"
	"chainmaker.org/chainmaker/opennet/servicecommon/copier"
	"chainmaker.org/chainmaker/opennet/servicecommon/res"
	"context"

	"cnbn-did/internal/svc"
	"cnbn-did/internal/types"

	"github.com/zeromicro/go-zero/core/logx"
)

type DelPublicKeyLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewDelPublicKeyLogic(ctx context.Context, svcCtx *svc.ServiceContext) *DelPublicKeyLogic {
	return &DelPublicKeyLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *DelPublicKeyLogic) DelPublicKey(req *types.DocumentDeletePublicKeyRequest) (resp *types.DocumentResponse, err error) {
	resp = &types.DocumentResponse{}
	if req.Password != "8u48934978897" {
		res.ServiceError.AddMessage("wrong password").BuildResult(resp)
		return resp, nil
	}

	in := &did.DocumentDeletePublicKeyRequest{}
	err = copier.Copy(req, in)
	if err != nil {
		return nil, err
	}
	result, err := l.svcCtx.DocumentService.DeletePublicKey(l.ctx, in)
	if err != nil {
		res.ServiceError.AddMessage("add public key filed").BuildResult(resp)
		return resp, nil
	}
	err = copier.Copy(result, resp)
	if err != nil {
		return nil, err
	}
	return
}
