/*
Copyright (C) BABEC. All rights reserved.

SPDX-License-Identifier: Apache-2.0
*/

package inner

import (
	vo "chainmaker.org/chainmaker/opennet/did/vo/did"
	"chainmaker.org/chainmaker/opennet/servicecommon/copier"
	"chainmaker.org/chainmaker/opennet/servicecommon/res"
	"chainmaker.org/chainmaker/opennet/servicecommon/res/code"
	"cnbn-did/errorcode"
	"encoding/json"

	"context"

	"cnbn-did/internal/svc"
	"cnbn-did/internal/types"

	"github.com/zeromicro/go-zero/core/logx"
)

type UpdateVcTemplateLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewUpdateVcTemplateLogic(ctx context.Context, svcCtx *svc.ServiceContext) *UpdateVcTemplateLogic {
	return &UpdateVcTemplateLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

type VcTemplateUpgradeRequestWithoutId struct {
	Name     string `json:"name"`
	Versions string `json:"versions"`
	Creator  string `json:"creator"`
	VcType   string `json:"vcType"`
}

func (l *UpdateVcTemplateLogic) UpdateVcTemplate(req *types.VcTemplateUpgradeRequest) (resp *types.VcTemplateUpgradeResponse, err error) {
	schemaReq := &types.VcTemplateSaveRequest{
		Name:                 req.Name,
		Versions:             req.Versions,
		Creator:              req.Creator,
		VcType:               req.VcType,
		Properties:           req.Properties,
		Required:             req.Required,
		AdditionalProperties: req.AdditionalProperties,
	}
	schemaBytes, err := json.Marshal(schemaReq)
	schema := string(schemaBytes)
	creatReq := &vo.VcTemplateUpgradeRequest{
		Id:       req.Id,
		Name:     req.Name,
		Versions: req.Versions,
		Creator:  req.Creator,
		VcType:   req.VcType,
		Schema:   schema,
	}

	result, err := l.svcCtx.VcTemplate.Upgrade(l.ctx, creatReq)
	if err != nil {
		errorcode.CommonCallServiceFailed.AddError(err).AddMessage("UpdateVcTemplate").BuildResult(resp)
		return resp, nil
	}
	resp = new(types.VcTemplateUpgradeResponse)
	if code.CodeOk.EqualsInt32(result.Code) {
		err = copier.Copy(&result, &resp)
		if err != nil {
			errorcode.ServiceResultException.AddError(err).AddMessage("UpdateVcTemplate").BuildResult(resp)
			return resp, nil
		}
		return resp, nil

	} else {
		res.ErrorMessageCode(code.Code(result.Code), result.Msg).AddMessage("UpdateVcTemplate code is not 200000").BuildResult(resp)
		return resp, nil
	}
	return
}
