/*
Copyright (C) BABEC. All rights reserved.

SPDX-License-Identifier: Apache-2.0
*/

package issuelog

import (
	vo "chainmaker.org/chainmaker/opennet/did/vo/did"
	"cnbn-did/internal/logic/common"
	"cnbn-did/internal/svc"
	"cnbn-did/internal/types"
	"context"
	"github.com/zeromicro/go-zero/core/logx"
)

type CreateLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
	common.BaseService[types.VerifiablePresentation, vo.VcIssueLogRequest, vo.VcIssueLogResponse, types.IssueLogCreateResponse]
}

func NewCreateLogic(ctx context.Context, svcCtx *svc.ServiceContext) *CreateLogic {
	c := &CreateLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
	c.Operation = svcCtx.VcIssuerLogService.VcIssuerLog
	return c
}

func (l *CreateLogic) Create(req *types.VerifiablePresentation) (resp *types.IssueLogCreateResponse, err error) {
	return
}
