/*
Copyright (C) BABEC. All rights reserved.

SPDX-License-Identifier: Apache-2.0
*/

package issuelog

import (
	vo "chainmaker.org/chainmaker/opennet/did/vo/did"
	"cnbn-did/internal/logic/common"
	"cnbn-did/internal/svc"
	"cnbn-did/internal/types"
	"context"

	"github.com/zeromicro/go-zero/core/logx"
)

type GetVcIssueLogsLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
	common.BaseService[types.IssueLogGetVcIssueLogsRequest, vo.GetVcIssueLogsRequest, vo.GetVcIssueLogsResponse, types.IssueLogGetVcIssueLogsResponse]
}

func NewGetVcIssueLogsLogic(ctx context.Context, svcCtx *svc.ServiceContext) *GetVcIssueLogsLogic {
	g := &GetVcIssueLogsLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
	g.Operation = svcCtx.VcIssuerLogService.GetVcIssueLogs
	return g
}

func (l *GetVcIssueLogsLogic) GetVcIssueLogs(req *types.IssueLogGetVcIssueLogsRequest) (resp *types.IssueLogGetVcIssueLogsResponse, err error) {
	return common.HandleRequest[types.IssueLogGetVcIssueLogsRequest, vo.GetVcIssueLogsRequest, vo.GetVcIssueLogsResponse, types.IssueLogGetVcIssueLogsResponse](l.ctx, l, req)
}
