/*
Copyright (C) BABEC. All rights reserved.

SPDX-License-Identifier: Apache-2.0
*/

package issuelog

import (
	vo "chainmaker.org/chainmaker/opennet/did/vo/did"
	"cnbn-did/internal/logic/common"
	"cnbn-did/internal/svc"
	"cnbn-did/internal/types"
	"context"

	"github.com/zeromicro/go-zero/core/logx"
)

type GetVcIssuersLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
	common.BaseService[types.IssueLogGetVcIssuersRequest, vo.GetVcIssuersRequest, vo.GetVcIssuersResponse, types.IssueLogGetVcIssuersResponse]
}

func NewGetVcIssuersLogic(ctx context.Context, svcCtx *svc.ServiceContext) *GetVcIssuersLogic {
	g := &GetVcIssuersLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
	g.Operation = svcCtx.VcIssuerLogService.GetVcIssuers
	return g
}

func (l *GetVcIssuersLogic) GetVcIssuers(req *types.IssueLogGetVcIssuersRequest) (resp *types.IssueLogGetVcIssuersResponse, err error) {
	return common.HandleRequest[types.IssueLogGetVcIssuersRequest, vo.GetVcIssuersRequest, vo.GetVcIssuersResponse, types.IssueLogGetVcIssuersResponse](l.ctx, l, req)
}
