/*
Copyright (C) BABEC. All rights reserved.

SPDX-License-Identifier: Apache-2.0
*/

package trustissuer

import (
	"cnbn-did/internal/logic/common"
	"context"

	vo "chainmaker.org/chainmaker/opennet/did/vo/did"

	"cnbn-did/internal/svc"
	"cnbn-did/internal/types"

	"github.com/zeromicro/go-zero/core/logx"
)

type AddLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
	common.BaseService[types.TrustIssuerAddRequest, vo.TrustIssuerRequest, vo.TrustIssuerResponse, types.TrustIssuerAddResponse]
}

func NewAddLogic(ctx context.Context, svcCtx *svc.ServiceContext) *AddLogic {
	s := &AddLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
	s.Operation = svcCtx.TrustIssuerService.Add
	return s
}

func (l *AddLogic) Add(req *types.TrustIssuerAddRequest) (resp *types.TrustIssuerAddResponse, err error) {
	return common.HandleRequest[types.TrustIssuerAddRequest, vo.TrustIssuerRequest,
		vo.TrustIssuerResponse, types.TrustIssuerAddResponse](l.ctx, l, req)
}
