/*
Copyright (C) BABEC. All rights reserved.

SPDX-License-Identifier: Apache-2.0
*/

package trustissuer

import (
	vo "chainmaker.org/chainmaker/opennet/did/vo/did"
	"cnbn-did/internal/logic/common"
	"cnbn-did/internal/svc"
	"cnbn-did/internal/types"
	"context"

	"github.com/zeromicro/go-zero/core/logx"
)

type ListLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
	common.BaseService[types.TrustIssuerFindListRequest, vo.ListTrustIssuerRequest, vo.ListTrustIssuerResponse, types.TrustIssuerFindListResponse]
}

func NewListLogic(ctx context.Context, svcCtx *svc.ServiceContext) *ListLogic {
	l := &ListLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
	l.Operation = svcCtx.TrustIssuerService.FindList
	return l
}

func (l *ListLogic) List(req *types.TrustIssuerFindListRequest) (resp *types.TrustIssuerFindListResponse, err error) {
	return common.HandleRequest[types.TrustIssuerFindListRequest, vo.ListTrustIssuerRequest, vo.ListTrustIssuerResponse,
		types.TrustIssuerFindListResponse](l.ctx, l, req)
}
