/*
Copyright (C) BABEC. All rights reserved.

SPDX-License-Identifier: Apache-2.0
*/

package vc

import (
	vo "chainmaker.org/chainmaker/opennet/did/vo/did"
	"chainmaker.org/chainmaker/opennet/servicecommon/copier"
	"chainmaker.org/chainmaker/opennet/servicecommon/res"
	"chainmaker.org/chainmaker/opennet/servicecommon/res/code"
	"cnbn-did/errorcode"
	"context"

	"cnbn-did/internal/svc"
	"cnbn-did/internal/types"

	"github.com/zeromicro/go-zero/core/logx"
)

type CheckListLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewCheckListLogic(ctx context.Context, svcCtx *svc.ServiceContext) *CheckListLogic {
	return &CheckListLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *CheckListLogic) CheckList(req *types.CheckListRequest) (resp *types.CheckListResponse, err error) {
	checkRevokeReq := &vo.CheckVcRevokeListRequest{}
	err = copier.Copy(&req, &checkRevokeReq)
	if err != nil {
		errorcode.InputException.AddError(err).AddMessage("CheckRevokeList").BuildResult(resp)
		return resp, nil
	}
	result, err := l.svcCtx.VcRevokeListService.CheckVcRevokeList(l.ctx, checkRevokeReq)
	if err != nil {
		errorcode.CommonCallServiceFailed.AddError(err).AddMessage("CheckRevokeList").BuildResult(resp)
		return resp, nil
	}

	resp = new(types.CheckListResponse)
	if code.CodeOk.NotEqualsInt32(result.Code) {
		res.ErrorMessageCode(code.Code(result.Code), result.Msg).AddMessage("CheckRevokeList code is not 200000").BuildResult(resp)
		return resp, nil
	}
	err = copier.Copy(&result, &resp)
	if err != nil {
		errorcode.ServiceResultException.AddError(err).AddMessage("CheckRevokeList").BuildResult(resp)
		return resp, nil
	}
	return resp, nil
}
