/*
Copyright (C) BABEC. All rights reserved.

SPDX-License-Identifier: Apache-2.0
*/

package vc

import (
	vo "chainmaker.org/chainmaker/opennet/did/vo/did"
	"chainmaker.org/chainmaker/opennet/servicecommon/copier"
	"cnbn-did/errorcode"
	"context"

	"cnbn-did/internal/svc"
	"cnbn-did/internal/types"

	"github.com/zeromicro/go-zero/core/logx"
)

type FindCompanyNameByDIDLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewFindCompanyNameByDIDLogic(ctx context.Context, svcCtx *svc.ServiceContext) *FindCompanyNameByDIDLogic {
	return &FindCompanyNameByDIDLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *FindCompanyNameByDIDLogic) FindCompanyNameByDID(req *types.FindCompanyNameByDIDRequest) (resp *types.FindCompanyNameByDIDResponse, err error) {
	in := &vo.FindCompanyNameByDIDRequest{}
	err = copier.Copy(&req, &in)
	if err != nil {
		errorcode.InputException.AddError(err).AddMessage("find company name by did").BuildResult(resp)
		return resp, nil
	}

	result, err := l.svcCtx.VcService.FindCompanyNameByDID(l.ctx, in)
	if err != nil {
		errorcode.CommonCallServiceFailed.AddError(err).AddMessage("find company name by did").BuildResult(resp)
		return resp, nil
	}

	err = copier.Copy(&result, &resp)
	if err != nil {
		errorcode.ServiceResultException.AddError(err).AddMessage("find company name by did").BuildResult(resp)
		return resp, nil
	}
	return resp, nil
}
