/*
Copyright (C) BABEC. All rights reserved.

SPDX-License-Identifier: Apache-2.0
*/

package vc

import (
	vo "chainmaker.org/chainmaker/opennet/did/vo/did"
	"chainmaker.org/chainmaker/opennet/servicecommon/copier"
	"cnbn-did/errorcode"
	"context"

	"cnbn-did/internal/svc"
	"cnbn-did/internal/types"

	"github.com/zeromicro/go-zero/core/logx"
)

type FindDIDByCompanyNameLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewFindDIDByCompanyNameLogic(ctx context.Context, svcCtx *svc.ServiceContext) *FindDIDByCompanyNameLogic {
	return &FindDIDByCompanyNameLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *FindDIDByCompanyNameLogic) FindDIDByCompanyName(req *types.FindDIDByCompanyNameRequest) (resp *types.FindDIDByCompanyNameResponse, err error) {
	in := &vo.FindDIDByCompanyNameRequest{}
	err = copier.Copy(&req, &in)
	if err != nil {
		errorcode.InputException.AddError(err).AddMessage("find did by company name").BuildResult(resp)
		return resp, nil
	}

	result, err := l.svcCtx.VcService.FindDIDByCompanyName(l.ctx, in)
	if err != nil {
		errorcode.CommonCallServiceFailed.AddError(err).AddMessage("find did by company name").BuildResult(resp)
		return resp, nil
	}

	err = copier.Copy(&result, &resp)
	if err != nil {
		errorcode.ServiceResultException.AddError(err).AddMessage("find did by company name").BuildResult(resp)
		return resp, nil
	}
	return resp, nil
}
