/*
Copyright (C) BABEC. All rights reserved.

SPDX-License-Identifier: Apache-2.0
*/

package vc

import (
	"chainmaker.org/chainmaker/opennet/did/vo/did"
	"chainmaker.org/chainmaker/opennet/servicecommon/copier"
	"cnbn-did/errorcode"
	"context"

	"cnbn-did/internal/svc"
	"cnbn-did/internal/types"

	"github.com/zeromicro/go-zero/core/logx"
)

type VcIssueLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewVcIssueLogic(ctx context.Context, svcCtx *svc.ServiceContext) *VcIssueLogic {
	return &VcIssueLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (s *VcIssueLogic) VcIssue(req *types.VcIssueRequest) (resp *types.VcIssueResponse, err error) {
	resp = &types.VcIssueResponse{}

	in := &did.VcIssueRequest{
		TemplateId:        req.TemplateId,
		Holder:            req.Holder,
		ExpirationDate:    req.ExpirationDate,
		IssuanceDate:      req.IssuanceDate,
		CredentialSubject: req.CredentialSubject,
	}
	if req.Proof != nil || len(req.Proof) != 0 {
		err = copier.Copy(req.Proof, &in.Proof)
		if err != nil {
			errorcode.CommonRequestCopyFailed.AddError(err).AddMessage("vc issue").BuildResult(resp)
			return resp, nil
		}
	}
	result, err := s.svcCtx.VcService.Issue(s.ctx, in)
	if err != nil {
		errorcode.CommonCallServiceFailed.AddError(err).AddMessage("vc issue").BuildResult(resp)
		return resp, nil
	}
	err = copier.Copy(result, resp)
	if err != nil {
		errorcode.CommonResponseCopyFailed.AddError(err).AddMessage("vc issue").BuildResult(resp)
		return resp, nil
	}
	return
}
