/*
Copyright (C) BABEC. All rights reserved.

SPDX-License-Identifier: Apache-2.0
*/

package vc

import (
	"chainmaker.org/chainmaker/opennet/servicecommon/res/code"
	"cnbn-did/errorcode"
	"cnbn-did/internal/svc"
	"cnbn-did/internal/types"
	"context"
	"encoding/json"

	vo "chainmaker.org/chainmaker/opennet/did/vo/did"
	"chainmaker.org/chainmaker/opennet/servicecommon/copier"
	"chainmaker.org/chainmaker/opennet/servicecommon/res"
	"chainweaver.org.cn/chainweaver/did/core"
	"github.com/zeromicro/go-zero/core/logx"
)

type VcListLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewVcListLogic(ctx context.Context, svcCtx *svc.ServiceContext) *VcListLogic {
	return &VcListLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (s *VcListLogic) VcList(req *types.VerifiablePresentation) (resp *types.VcListResponse, err error) {
	vp := &core.VerifiablePresentation{}
	resp = &types.VcListResponse{}
	err = copier.Copy(&req, &vp)
	if err != nil {
		errorcode.InputException.AddError(err).AddMessage("VcList").BuildResult(resp)
		return resp, nil
	}

	verifyReq := &vo.VpRequestWrapper{
		Vp: vp,
	}
	response, err := s.svcCtx.VerifyService.Vp(s.ctx, verifyReq)
	if err != nil {
		errorcode.CommonCallServiceFailed.AddError(err).AddMessage("VcList中VerifyVp").BuildResult(resp)
		return resp, nil
	}

	if code.CodeOk.NotEqualsInt32(response.Code) {
		err = copier.Copy(&response, &resp)
		if err != nil {
			errorcode.ServiceResultException.AddError(err).AddMessage("VcList中VerifyVp").BuildResult(resp)
			return resp, nil
		}
		return
	}
	for _, proof := range verifyReq.Vp.Proof {
		did, _, err := core.SplitVerificationId(proof.VerificationMethod)
		if err != nil {
			errorcode.CommonCallServiceFailed.AddError(err).AddMessage("SplitVerificationId").BuildResult(resp)
			return resp, nil
		}
		listReq := &vo.VcListRequest{}
		err = json.Unmarshal(vp.Extend, listReq)
		if err != nil {
			errorcode.CommonUnmarshalException.AddError(err).AddMessage("VcListRequest").BuildResult(resp)
			return resp, nil
		}
		listReq.Holder = did
		result, err := s.svcCtx.VcService.List(s.ctx, listReq)
		if err != nil {
			errorcode.CommonCallServiceFailed.AddError(err).AddMessage("VcList").BuildResult(resp)
			return resp, nil
		}

		resp = new(types.VcListResponse)
		if code.CodeOk.EqualsInt32(result.Code) {
			err = copier.Copy(&result, &resp)
			if err != nil {
				errorcode.ServiceResultException.AddError(err).AddMessage("VcList").BuildResult(resp)
				return resp, nil
			}
			return resp, nil
			//resp.Msg = result.Msg
			//resp.Code = result.Code
			//resp.Data.Page.Page = result.Data.Page.Page
			//resp.Data.Page.Size = result.Data.Page.Size
			//resp.Data.Page.Total = result.Data.Page.Total
			//l := len(result.Data.List)
			//resp.Data.List = make([]types.VcListResponseItem, l)
			//if l > 0 {
			//	for i, item := range result.Data.List {
			//		vcBytes, err := json.Marshal(item.Vc)
			//		if err != nil {
			//			logx.Errorf("3333333", err)
			//			return nil, err
			//		}
			//		resp.Data.List[i].Vc = string(vcBytes)
			//	}
			//} else {
			//	fmt.Print(l)
			//}

		} else {
			res.ErrorMessageCode(code.Code(result.Code), result.Msg).AddMessage("VcList code is not 200000").BuildResult(resp)
			return resp, nil
		}
	}
	return resp, nil
}
