/*
Copyright (C) BABEC. All rights reserved.

SPDX-License-Identifier: Apache-2.0
*/

package vc

import (
	vo "chainmaker.org/chainmaker/opennet/did/vo/did"
	"chainmaker.org/chainmaker/opennet/servicecommon/copier"
	"chainmaker.org/chainmaker/opennet/servicecommon/res"
	"chainmaker.org/chainmaker/opennet/servicecommon/res/code"
	"cnbn-did/errorcode"
	"cnbn-did/internal/svc"
	"cnbn-did/internal/types"
	"context"
	"encoding/json"

	"github.com/zeromicro/go-zero/core/logx"
)

type VcListUserLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewVcListUserLogic(ctx context.Context, svcCtx *svc.ServiceContext) *VcListUserLogic {
	return &VcListUserLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (l *VcListUserLogic) VcListUser(req *types.VcListRequest) (resp *types.VcListResponse, err error) {
	resp = &types.VcListResponse{}
	bytes, err := json.Marshal(req)
	if err != nil {
		errorcode.CommonMarshalException.AddError(err).AddMessage("VcListRequest").BuildResult(resp)
		return resp, nil
	}
	listReq := &vo.VcListRequest{}
	err = json.Unmarshal(bytes, listReq)
	if err != nil {
		errorcode.CommonUnmarshalException.AddError(err).AddMessage("VcListUserRequest").BuildResult(resp)
		return resp, nil
	}

	result, err := l.svcCtx.VcService.List(l.ctx, listReq)
	if err != nil {
		errorcode.CommonCallServiceFailed.AddError(err).AddMessage("VcListUser").BuildResult(resp)
		return resp, nil
	}

	resp = new(types.VcListResponse)
	if code.CodeOk.EqualsInt32(result.Code) {
		err = copier.Copy(&result, &resp)
		if err != nil {
			errorcode.ServiceResultException.AddError(err).AddMessage("VcListUser").BuildResult(resp)
			return resp, nil
		}
		return resp, nil
	} else {
		res.ErrorMessageCode(code.Code(result.Code), result.Msg).AddMessage("VcList code is not 200000").BuildResult(resp)
		return resp, nil
	}
}
