/*
Copyright (C) BABEC. All rights reserved.

SPDX-License-Identifier: Apache-2.0
*/

package vc

import (
	"chainmaker.org/chainmaker/opennet/servicecommon/res/code"
	"cnbn-did/errorcode"
	"cnbn-did/internal/svc"
	"cnbn-did/internal/types"
	"context"
	"encoding/json"

	vo "chainmaker.org/chainmaker/opennet/did/vo/did"
	"chainmaker.org/chainmaker/opennet/servicecommon/copier"
	"chainmaker.org/chainmaker/opennet/servicecommon/res"
	"chainweaver.org.cn/chainweaver/did/core"
	"github.com/zeromicro/go-zero/core/logx"
)

type VcRevokeLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewVcRevokeLogic(ctx context.Context, svcCtx *svc.ServiceContext) *VcRevokeLogic {
	return &VcRevokeLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
}

func (s *VcRevokeLogic) VcRevoke(req *types.VerifiablePresentation) (resp *types.VcRevokeResponse, err error) {
	vp := &core.VerifiablePresentation{}
	resp = &types.VcRevokeResponse{}
	err = copier.Copy(&req, &vp)
	if err != nil {
		errorcode.InputException.AddError(err).AddMessage("VcRevoke").BuildResult(resp)
		return resp, nil
	}

	verifyReq := &vo.VpRequestWrapper{
		Vp: vp,
	}
	response, err := s.svcCtx.VerifyService.Vp(s.ctx, verifyReq)
	if err != nil {
		errorcode.CommonCallServiceFailed.AddError(err).AddMessage("VcRevoke中VerifyVp").BuildResult(resp)
		return resp, nil
	}

	if code.CodeOk.NotEqualsInt32(response.Code) {
		err = copier.Copy(&response, &resp)
		if err != nil {
			errorcode.ServiceResultException.AddError(err).AddMessage("VcRevoke中VerifyVp").BuildResult(resp)
			return resp, nil
		}
	}

	vcRecokeReq := &vo.VcRevokeRequest{}
	err = json.Unmarshal(vp.Extend, &vcRecokeReq.VcIds)
	if err != nil {
		errorcode.CommonUnmarshalException.AddError(err).AddMessage("VcRevokeRequest").BuildResult(resp)
		return resp, nil
	}
	result, err := s.svcCtx.VcService.Revoke(s.ctx, vcRecokeReq)
	if err != nil {
		errorcode.CommonCallServiceFailed.AddError(err).AddMessage("VcRevoke").BuildResult(resp)
		return resp, nil
	}
	resp = new(types.VcRevokeResponse)
	if code.CodeOk.EqualsInt32(result.Code) {
		err = copier.Copy(&result, &resp)
		if err != nil {
			errorcode.ServiceResultException.AddError(err).AddMessage("VcRevoke").BuildResult(resp)
			return resp, nil
		}
		return resp, nil

	} else {
		res.ErrorMessageCode(code.Code(result.Code), result.Msg).AddMessage("VcRevoke code is not 200000").BuildResult(resp)
		return resp, nil
	}
}
