package vctemplate

import (
	vo "chainmaker.org/chainmaker/opennet/did/vo/did"
	"chainmaker.org/chainmaker/opennet/servicecommon/copier"
	"chainmaker.org/chainmaker/opennet/servicecommon/res"
	"chainmaker.org/chainmaker/opennet/servicecommon/res/code"
	"cnbn-did/errorcode"
	"cnbn-did/internal/svc"
	"cnbn-did/internal/types"
	"context"
	"encoding/json"
	"github.com/zeromicro/go-zero/core/logx"
)

type CreatevctemplateLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
}

func NewCreatevctemplateLogic(ctx context.Context, svcCtx *svc.ServiceContext) *CreatevctemplateLogic {
	c := &CreatevctemplateLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
	return c
}

func (l *CreatevctemplateLogic) Createvctemplate(req *types.VcTemplateSaveRequest) (resp *types.VcTemplateSaveResponse, err error) {
	schemaBytes, err := json.Marshal(req)
	schema := string(schemaBytes)
	creatReq := &vo.VcTemplateSaveRequest{
		Name:     req.Name,
		Versions: req.Versions,
		Creator:  req.Creator,
		VcType:   req.VcType,
		Schema:   schema,
	}

	result, err := l.svcCtx.VcTemplate.Create(l.ctx, creatReq)
	if err != nil {
		errorcode.CommonCallServiceFailed.AddError(err).AddMessage("Createvctemplate").BuildResult(resp)
		return resp, nil
	}
	resp = new(types.VcTemplateSaveResponse)
	if code.CodeOk.EqualsInt32(result.Code) {
		err = copier.Copy(&result, &resp)
		if err != nil {
			errorcode.ServiceResultException.AddError(err).AddMessage("Createvctemplate").BuildResult(resp)
			return resp, nil
		}
		return resp, nil

	} else {
		res.ErrorMessageCode(code.Code(result.Code), result.Msg).AddMessage("Createvctemplate code is not 200000").BuildResult(resp)
		return resp, nil
	}
	return
}
