package vctemplate

import (
	vo "chainmaker.org/chainmaker/opennet/did/vo/did"
	"chainmaker.org/chainmaker/opennet/servicecommon/copier"
	"chainmaker.org/chainmaker/opennet/servicecommon/res"
	"chainmaker.org/chainmaker/opennet/servicecommon/res/code"
	"cnbn-did/errorcode"
	"cnbn-did/internal/logic/common"
	"cnbn-did/internal/svc"
	"cnbn-did/internal/types"
	"context"
	"encoding/json"
	"github.com/zeromicro/go-zero/core/logx"
)

type OnequeryvctemplateLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
	common.BaseService[types.VcTemplateId, vo.VcTemplateId, vo.VcTemplateOneResponse, types.VcTemplateOneResponse]
}

func NewOnequeryvctemplateLogic(ctx context.Context, svcCtx *svc.ServiceContext) *OnequeryvctemplateLogic {
	o := &OnequeryvctemplateLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
	o.Operation = svcCtx.VcTemplate.One
	return o
}

func (l *OnequeryvctemplateLogic) Onequeryvctemplate(req *types.VcTemplateId) (resp *types.VcTemplateOneResponse, err error) {
	oneQueryReq := &vo.VcTemplateId{Id: req.Id}

	result, err := l.svcCtx.VcTemplate.One(l.ctx, oneQueryReq)
	if err != nil {
		errorcode.CommonCallServiceFailed.AddError(err).AddMessage("Onequeryvctemplate").BuildResult(resp)
		return resp, nil
	}
	resp = new(types.VcTemplateOneResponse)
	if code.CodeOk.EqualsInt32(result.Code) {
		err = copier.Copy(&result, &resp)
		if err != nil {
			errorcode.ServiceResultException.AddError(err).AddMessage("Onequeryvctemplate").BuildResult(resp)
			return resp, nil
		}
		var shema1 VcTemplateSchema
		err = json.Unmarshal([]byte(result.Data.Schema), &shema1)
		resp.Data.Schema = shema1.Schema
		resp.Data.Creator = shema1.Creator
		resp.Data.Id = result.Data.Id
		resp.Data.Name = result.Data.Name
		resp.Data.Type = shema1.Type
		resp.Data.VcType = shema1.VcType
		resp.Data.Created = result.Data.Created
		resp.Data.Required = shema1.Required
		var properties = make(map[string]types.PropertyObj)
		for key, value := range shema1.Properties {
			properties[key] = types.PropertyObj{
				Type:      value.Type,
				Title:     value.Title,
				Pattern:   value.Pattern,
				Desc:      value.Desc,
				Enum:      value.Enum,
				Minimum:   value.Minimum,
				Maximum:   value.Maximum,
				MinLength: value.MinLength,
				MaxLength: value.MaxLength,
				Format:    value.Format,
			}
		}
		resp.Data.Properties = properties
		resp.Data.AdditionalProperties = shema1.AdditionalProperties
		resp.Data.Versions = result.Data.Version
		return resp, nil

	} else {
		res.ErrorMessageCode(code.Code(result.Code), result.Msg).AddMessage("Onequeryvctemplate code is not 200000").BuildResult(resp)
		return resp, nil
	}
	return
}
