package vctemplate

import (
	vo "chainmaker.org/chainmaker/opennet/did/vo/did"
	"chainmaker.org/chainmaker/opennet/servicecommon/copier"
	"chainmaker.org/chainmaker/opennet/servicecommon/res"
	"chainmaker.org/chainmaker/opennet/servicecommon/res/code"
	"cnbn-did/errorcode"
	"cnbn-did/internal/logic/common"
	"cnbn-did/internal/svc"
	"cnbn-did/internal/types"
	"context"
	"encoding/json"
	"fmt"
	"github.com/zeromicro/go-zero/core/logx"
)

type PagequeryvctemplateLogic struct {
	logx.Logger
	ctx    context.Context
	svcCtx *svc.ServiceContext
	common.BaseService[types.VcTemplatePageRequest, vo.VcTemplatePageRequest, vo.VcTemplatePageResponse, types.VcTemplatePageResponse]
}

func NewPagequeryvctemplateLogic(ctx context.Context, svcCtx *svc.ServiceContext) *PagequeryvctemplateLogic {
	p := &PagequeryvctemplateLogic{
		Logger: logx.WithContext(ctx),
		ctx:    ctx,
		svcCtx: svcCtx,
	}
	p.Operation = svcCtx.VcTemplate.List
	return p
}

type PropertiesObj struct {
	Type      string   `json:"type"`
	Title     string   `json:"title"`
	Pattern   string   `json:"pattern,omitempty,optional"`
	Desc      string   `json:"desc,omitempty,optional"`
	Enum      []string `json:"enum,omitempty,optional"`      // 用于枚举类型的值
	Minimum   *float64 `json:"minimum,omitempty,optional"`   // 用于数字类型的最小值
	Maximum   *float64 `json:"maximum,omitempty,optional"`   // 用于数字类型的最大值
	MinLength *int     `json:"minLength,omitempty,optional"` // 用于字符串类型的最小长度
	MaxLength *int     `json:"maxLength,omitempty,optional"` // 用于字符串类型的最大长度
	Format    string   `json:"format,omitempty,optional"`    // 用于字符串类型的格式（如日期、电子邮件等)
}

// VcTemplateSchema
// @Description: 定义VcTemplate中Schema结构体
type VcTemplateSchema struct {
	Name                 string                   `json:"name"`
	Creator              string                   `json:"creator"`
	Type                 string                   `json:"type"`
	VcType               string                   `json:"vcType"`
	Schema               string                   `json:"$schema"`
	Properties           map[string]PropertiesObj `json:"properties"`
	Required             []string                 `json:"required"`
	AdditionalProperties bool                     `json:"additionalProperties"`
	Version              string                   `json:"version"`
}

func (l *PagequeryvctemplateLogic) Pagequeryvctemplate(req *types.VcTemplatePageRequest) (resp *types.VcTemplatePageResponse, err error) {
	listReq := &vo.VcTemplatePageRequest{}
	err = copier.Copy(&req, &listReq)
	if err != nil {
		errorcode.InputException.AddError(err).AddMessage("Pagequeryvctemplate").BuildResult(resp)
		return resp, nil
	}
	result, err := l.svcCtx.VcTemplate.List(l.ctx, listReq)
	if err != nil {
		errorcode.CommonCallServiceFailed.AddError(err).AddMessage("Pagequeryvctemplate").BuildResult(resp)
		return resp, nil
	}
	resp = new(types.VcTemplatePageResponse)
	list := make([]types.VcTemplateDetail, len(result.Data.List))

	if code.CodeOk.EqualsInt32(result.Code) {
		resp.Msg = result.Msg
		resp.Code = result.Code
		resp.Data.Page.Page = result.Data.Page.Page
		resp.Data.Page.Size = result.Data.Page.Size
		resp.Data.Page.Total = result.Data.Page.Total
		for i := range list {
			var shema1 VcTemplateSchema
			err = json.Unmarshal([]byte(result.Data.List[i].Schema), &shema1)
			list[i].Schema = shema1.Schema
			list[i].Creator = result.Data.List[i].Creator
			list[i].Id = result.Data.List[i].Id
			list[i].Name = result.Data.List[i].Name
			list[i].Type = shema1.Type
			list[i].VcType = shema1.VcType
			list[i].Created = result.Data.List[i].Created
			list[i].Required = shema1.Required
			var properties = make(map[string]types.PropertyObj)
			for key, value := range shema1.Properties {
				properties[key] = types.PropertyObj{
					Type:      value.Type,
					Title:     value.Title,
					Pattern:   value.Pattern,
					Desc:      value.Desc,
					Enum:      value.Enum,
					Minimum:   value.Minimum,
					Maximum:   value.Maximum,
					MinLength: value.MinLength,
					MaxLength: value.MaxLength,
					Format:    value.Format,
				}
			}
			list[i].Properties = properties
			list[i].AdditionalProperties = shema1.AdditionalProperties
			list[i].Versions = result.Data.List[i].Version
		}

		resp.Data.List = list
		r, _ := json.Marshal(resp)
		fmt.Println(r)
		return resp, nil

	} else {
		res.ErrorMessageCode(code.Code(result.Code), result.Msg).AddMessage("Createvctemplate code is not 200000").BuildResult(resp)
		return resp, nil
	}
	return
}
