/*
Copyright (C) BABEC. All rights reserved.

SPDX-License-Identifier: Apache-2.0
*/

package svc

import (
	"chainmaker.org/chainmaker/opennet/did/client/blacklistservice"
	"chainmaker.org/chainmaker/opennet/did/client/didservice"
	"chainmaker.org/chainmaker/opennet/did/client/documentservice"
	"chainmaker.org/chainmaker/opennet/did/client/generateservice"
	"chainmaker.org/chainmaker/opennet/did/client/trustissuerservice"
	"chainmaker.org/chainmaker/opennet/did/client/vcissuerlogservice"
	"chainmaker.org/chainmaker/opennet/did/client/vcrevokelistservice"
	"chainmaker.org/chainmaker/opennet/did/client/vcservice"
	"chainmaker.org/chainmaker/opennet/did/client/vctemplateservice"
	"chainmaker.org/chainmaker/opennet/did/client/verifyservice"
	"cnbn-did/internal/config"
	"github.com/zeromicro/go-zero/zrpc"
)

type ServiceContext struct {
	Config              config.Config
	DocumentService     documentservice.DocumentService
	DidService          didservice.DidService
	VcTemplate          vctemplateservice.VcTemplateService
	VerifyService       verifyservice.VerifyService
	TrustIssuerService  trustissuerservice.TrustIssuerService
	VcIssuerLogService  vcissuerlogservice.VcIssuerLogService
	VcService           vcservice.VcService
	GenerateService     generateservice.GenerateService
	BlackListService    blacklistservice.BlackListService
	VcRevokeListService vcrevokelistservice.VcRevokeListService
}

func NewServiceContext(c config.Config) *ServiceContext {

	return &ServiceContext{
		Config: c,
		DidService: didservice.NewDidService(zrpc.MustNewClient(zrpc.RpcClientConf{
			Target: c.GrpcTarget,
		})),
		VcTemplate: vctemplateservice.NewVcTemplateService(zrpc.MustNewClient(zrpc.RpcClientConf{
			Target: c.GrpcTarget,
		})),
		VerifyService: verifyservice.NewVerifyService(zrpc.MustNewClient(zrpc.RpcClientConf{
			Target: c.GrpcTarget,
		})),
		TrustIssuerService: trustissuerservice.NewTrustIssuerService(zrpc.MustNewClient(zrpc.RpcClientConf{
			Target: c.GrpcTarget,
		})),
		VcIssuerLogService: vcissuerlogservice.NewVcIssuerLogService(zrpc.MustNewClient(zrpc.RpcClientConf{
			Target: c.GrpcTarget,
		})),
		VcService: vcservice.NewVcService(zrpc.MustNewClient(zrpc.RpcClientConf{
			Target: c.GrpcTarget,
		})),
		GenerateService: generateservice.NewGenerateService(zrpc.MustNewClient(zrpc.RpcClientConf{
			Target: c.GrpcTarget,
		})),
		DocumentService: documentservice.NewDocumentService(zrpc.MustNewClient(zrpc.RpcClientConf{
			Target: c.GrpcTarget,
		})),
		BlackListService: blacklistservice.NewBlackListService(zrpc.MustNewClient(zrpc.RpcClientConf{
			Target: c.GrpcTarget,
		})),
		VcRevokeListService: vcrevokelistservice.NewVcRevokeListService(zrpc.MustNewClient(zrpc.RpcClientConf{
			Target: c.GrpcTarget,
		})),
	}
}
