/*
Copyright (C) BABEC. All rights reserved.

SPDX-License-Identifier: Apache-2.0
*/
package types

import "encoding/json"

type XXXXXRawMessage struct {
}

type Document struct {
	Context            []string             `json:"@context,omitempty,optional"`
	Authentication     []string             `json:"authentication,omitempty,optional"`
	Controller         []string             `json:"controller,omitempty,optional"`
	Created            string               `json:"created,omitempty,optional"`
	Id                 string               `json:"id,omitempty,optional"`
	Proof              []Proof              `json:"proof,omitempty,optional"`
	Service            []Service            `json:"service,omitempty,optional"`
	UnionId            map[string]string    `json:"unionId,omitempty,optional"`
	Updated            string               `json:"updated,omitempty,optional"`
	VerificationMethod []VerificationMethod `json:"verificationMethod,omitempty,optional"`
}

type Proof struct {
	Challenge           string               `json:"challenge,omitempty,optional"`
	Created             string               `json:"created,omitempty,optional"`
	ExcludedFields      []string             `json:"excludedFields,omitempty,optional"`
	ProofPurpose        string               `json:"proofPurpose,omitempty,optional"`
	ProofValue          []byte               `json:"proofValue,omitempty,optional"`
	SelectiveDisclosure *SelectiveDisclosure `json:"selectiveDisclosure,omitempty"`
	SignedFields        []string             `json:"signedFields,omitempty,optional"`
	Type                string               `json:"type,omitempty,optional"`
	VerificationMethod  string               `json:"verificationMethod,omitempty,optional"`
}

type SelectiveDisclosure struct {
	HashType   string      `json:"hashType,omitempty"`
	MerkleRoot []byte      `json:"merkleRoot,omitempty"`
	Seed       []byte      `json:"seed,omitempty"`
	Salt       [][]byte    `json:"salt,omitempty"`
	MerklePath *MerklePath `json:"merklePath,omitempty"`
}

type MerklePath struct {
	Leaf uint32           `json:"leaf,omitempty"`
	Path map[int32][]byte `json:"path,omitempty"`
}

type Service struct {
	Id              string `json:"id,omitempty,optional"`
	ServiceEndpoint string `json:"serviceEndpoint,omitempty,optional"`
	Type            string `json:"type,omitempty,optional"`
}

type VerificationMethod struct {
	Address      string `json:"address,omitempty,optional"`
	Controller   string `json:"controller,omitempty,optional"`
	Id           string `json:"id,omitempty,optional"`
	PublicKeyPem string `json:"publicKeyPem,omitempty,optional"`
	Type         string `json:"type,omitempty,optional"`
}

type VerifiableCredential struct {
	Context           []string        `json:"@context,omitempty,optional"`
	CredentialSubject json.RawMessage `json:"credentialSubject,omitempty,optional"`
	ExpirationDate    string          `json:"expirationDate,omitempty,optional"`
	Holder            string          `json:"holder,omitempty,optional"`
	Id                string          `json:"id,omitempty,optional"`
	IssuanceDate      string          `json:"issuanceDate,omitempty,optional"`
	Issuer            string          `json:"issuer,omitempty,optional"`
	Proof             []Proof         `json:"proof,omitempty,optional"`
	Template          VcTemplate      `json:"template,omitempty,optional"`
	Type              []string        `json:"type,omitempty,optional"`
}

type VcTemplate struct {
	Id      string `json:"id,omitempty,optional"`
	Name    string `json:"name,omitempty,optional"`
	VcType  string `json:"vcType,omitempty,optional"`
	Version string `json:"version,omitempty,optional"`
}

type VerifiablePresentation struct {
	Context              []string               `json:"@context,omitempty,optional"`
	ExpirationDate       string                 `json:"expirationDate,omitempty,optional"`
	Extend               json.RawMessage        `json:"extend,omitempty,optional"`
	Id                   string                 `json:"id,omitempty,optional"`
	PresentationUsage    string                 `json:"presentationUsage,omitempty,optional"`
	Proof                []Proof                `json:"proof,omitempty,optional"`
	Timestamp            string                 `json:"timestamp,omitempty,optional"`
	Type                 string                 `json:"type,omitempty,optional"`
	VerifiableCredential []VerifiableCredential `json:"verifiableCredential,omitempty,optional"`
	Verifier             string                 `json:"verifier,omitempty,optional"`
}

type LongPlaintext struct {
	Type      int    `json:"type"`
	Plaintext []byte `json:"plaintext"`
}

type DocumentRegisterRequest struct {
	Did   string          `json:"did"`
	Proof Proof           `json:"proof"`
	Issue *VcIssueRequest `json:"issue,omitempty,optional"`
}

type DocumentUpdateRequest struct {
	Did      string    `json:"did,omitempty,optional"`
	Proof    []Proof   `json:"proof,omitempty,optional"`
	Document *Document `json:"document,omitempty,optional"`
}

type DocumentGetRequest struct {
	Did string `json:"did,omitempty"`
}

type DocumentGetListRequest struct {
	Did []string `json:"did,omitempty"`
}

type DocumentGetByAddressRequest struct {
	Address string `json:"address,omitempty"`
}

type DocumentImportRequest struct {
	Password string   `header:"password"`
	Document Document `json:"document,omitempty"`
}

type DocumentAddPublicKeyRequest struct {
	Password  string `header:"password"`
	Did       string `json:"did"`
	PublicKey string `json:"publicKey"`
}

type DocumentDeletePublicKeyRequest struct {
	Password       string `header:"password"`
	VerificationId string `json:"verificationId"`
}

type DocumentResponse struct {
	Code int32                `json:"code"`
	Msg  string               `json:"msg"`
	Data DocumentResponseData `json:"data"`
}

type DocumentListResponse struct {
	Code int32            `json:"code"`
	Msg  string           `json:"msg"`
	Data DocumentListData `json:"data"`
}

type DocumentListData struct {
	Document []json.RawMessage `json:"document"`
}

type DocumentResponseData struct {
	Document json.RawMessage `json:"document,omitempty"`
}

type DocumentRegisterResponse struct {
	Code int32                        `json:"code"`
	Msg  string                       `json:"msg"`
	Data DocumentRegisterResponseData `json:"data"`
}

type DocumentRegisterResponseData struct {
	Document Document              `json:"document"`
	Vc       *VerifiableCredential `json:"vc,omitempty"`
}

type VcTemplateUpgradeRequest struct {
	Id                   string                 `json:"id"`
	Name                 string                 `json:"name"`
	Versions             string                 `json:"versions"`
	Creator              string                 `json:"creator"`
	VcType               string                 `json:"vcType"`
	Properties           map[string]PropertyObj `json:"properties"`
	Required             []string               `json:"required"`
	AdditionalProperties bool                   `json:"additionalProperties"`
}

type VcTemplateUpgradeResponse struct {
	Code int32  `json:"code"`
	Msg  string `json:"msg"`
}

type DidGenerateRequest struct {
	PublicKey          []string `json:"publicKey"`
	Name               string   `json:"name"`
	IdentityCardNumber string   `json:"identityCardNumber"`
	Phone              string   `json:"phone"`
}

type DidGenerateResponse struct {
	Code int32                   `json:"code"`
	Msg  string                  `json:"msg"`
	Data DidGenerateResponseData `json:"data"`
}

type DidGenerateResponseData struct {
	Did       string          `json:"did"`
	Plaintext []LongPlaintext `json:"plaintext"`
}

type DidRegisterRequest struct {
	Did                string      `json:"did"`
	Name               string      `json:"name"`
	IdentityCardNumber string      `json:"identityCardNumber"`
	Phone              string      `json:"phone"`
	RegisterProof      []LongProof `json:"registerProof"`
}

type LongProof struct {
	Type  int32    `json:"type,optional"`
	Proof SODProof `json:"proof"`
}

type SODProof struct {
	Proof     Proof  `json:"proof"`
	Plaintext []byte `json:"plaintext"`
}

type DidRegisterResponse struct {
	Code int32                   `json:"code"`
	Msg  string                  `json:"msg"`
	Data DidRegisterResponseData `json:"data"`
}

type DidRegisterResponseData struct {
	Document Document             `json:"document"`
	Vc       VerifiableCredential `json:"vc"`
}

type GenUpdateDocumentResponse struct {
	Code int32                         `json:"code"`
	Msg  string                        `json:"msg"`
	Data GenUpdateDocumentResponseData `json:"data"`
}

type GenUpdateDocumentResponseData struct {
	Did       string        `json:"did"`
	Plaintext LongPlaintext `json:"plaintext"`
}

type GenCnbnVpResponse struct {
	Code int32                 `json:"code"`
	Msg  string                `json:"msg"`
	Data GenCnbnVpResponseData `json:"data"`
}

type GenCnbnVpResponseData struct {
	Vp VerifiablePresentation `json:"vp"`
}

type GenUpdateDocumentVerificationMethodRequest struct {
	Did       string   `json:"did"`
	PublicKey []string `json:"publicKey,optional"`
	Addresses []string `json:"addresses"`
	Action    int32    `path:"action"`
}

type GenUpdateDocumentServiceRequest struct {
	Did     string  `json:"did"`
	Service Service `json:"service"`
	Action  int32   `path:"action"`
}

type GenDocumentRegisterRequest struct {
	Did       string            `json:"did,optional"`
	PublicKey []string          `json:"publicKey,optional"`
	UnionId   map[string]string `json:"unionId,optional"`
	Service   *Service          `json:"service,optional"`
}

type GenDocumentRegisterResponse struct {
	Code int32                           `json:"code"`
	Msg  string                          `json:"msg"`
	Data GenDocumentRegisterResponseData `json:"data"`
}

type GenDocumentRegisterResponseData struct {
	Did       string `json:"did"`
	Plaintext []byte `json:"plaintext"`
}

type GenVerifyVPRequest struct {
	Extend map[string]interface{} `json:"extend"`
}

type VcListRequest struct {
	Page       PageVcListUser `json:"page,optional"`
	Issuer     string         `json:"issuer,optional"`
	Holder     string         `json:"holder,optional"`
	TemplateId string         `json:"templateId,optional"`
	Status     int32          `json:"status,optional"`
}

type PageVcListUser struct {
	Page int32 `json:"page"`
	Size int32 `json:"size"`
}

type VcListResponse struct {
	Code int32              `json:"code"`
	Msg  string             `json:"msg"`
	Data VcListResponseData `json:"data"`
}

type VcListResponseData struct {
	Page Page                 `json:"page"`
	List []VcListResponseItem `json:"list"`
}

type VcListResponseItem struct {
	Status int32           `json:"status"`
	Vc     json.RawMessage `json:"vc"`
}

type VcIssueRequest struct {
	TemplateId        string          `json:"templateId"`
	Holder            string          `json:"holder"`
	ExpirationDate    string          `json:"expirationDate"`
	IssuanceDate      string          `json:"issuanceDate"`
	CredentialSubject json.RawMessage `json:"credentialSubject,omitempty,optional"`
	Proof             []LongProof     `json:"proof,omitempty,optional"`
}

type VcIssueResponse struct {
	Code int32               `json:"code"`
	Msg  string              `json:"msg"`
	Data VcIssueResponseData `json:"data"`
}

type VcIssueResponseData struct {
	Vc string `json:"vc"`
}

type VcRevokeRequest struct {
	VcId []string `json:"vcId"`
}

type VcRevokeResponse struct {
	Code int32  `json:"code"`
	Msg  string `json:"msg"`
}

type FindDIDByCompanyNameRequest struct {
	CompanyName string `json:"companyName"`
}

type FindDIDByCompanyNameResponse struct {
	Code int32                    `json:"code"`
	Msg  string                   `json:"msg"`
	Data FindDIDByCompanyNameData `json:"data,omitempty"`
}

type FindDIDByCompanyNameData struct {
	Did string `json:"did"`
}

type FindCompanyNameByDIDRequest struct {
	Did string `json:"did"`
}

type FindCompanyNameByDIDResponse struct {
	Code int32                            `json:"code"`
	Msg  string                           `json:"msg"`
	Data FindCompanyNameByDIDResponseData `json:"data,omitempty"`
}

type FindCompanyNameByDIDResponseData struct {
	CompanyName string `json:"companyName"`
}

type VcTemplateSaveRequest struct {
	Name                 string                 `json:"name"`
	Versions             string                 `json:"versions"`
	Creator              string                 `json:"creator"`
	VcType               string                 `json:"vcType"`
	Properties           map[string]PropertyObj `json:"properties"`
	Required             []string               `json:"required"`
	AdditionalProperties bool                   `json:"additionalProperties"`
}

type PropertyObj struct {
	Type      string   `json:"type"`
	Title     string   `json:"title"`
	Pattern   string   `json:"pattern,omitempty,optional"`
	Desc      string   `json:"desc,omitempty,optional"`
	Enum      []string `json:"enum,omitempty,optional"`      // 用于枚举类型的值
	Minimum   *float64 `json:"minimum,omitempty,optional"`   // 用于数字类型的最小值
	Maximum   *float64 `json:"maximum,omitempty,optional"`   // 用于数字类型的最大值
	MinLength *int     `json:"minLength,omitempty,optional"` // 用于字符串类型的最小长度
	MaxLength *int     `json:"maxLength,omitempty,optional"` // 用于字符串类型的最大长度
	Format    string   `json:"format,omitempty,optional"`    // 用于字符串类型的格式（如日期、电子邮件等）
}

type VcTemplateSaveResponse struct {
	Code int32        `json:"code"`
	Msg  string       `json:"msg"`
	Data VcTemplateId `json:"data"`
}

type VcTemplateId struct {
	Id string `json:"id"`
}

type VcTemplateOneResponse struct {
	Code int32            `json:"code"`
	Msg  string           `json:"msg"`
	Data VcTemplateDetail `json:"data"`
}

type VcTemplateDetail struct {
	Id                   string                 `json:"id"`
	Name                 string                 `json:"name"`
	Versions             string                 `json:"versions"`
	Schema               string                 `json:"$schema"`
	Type                 string                 `json:"type"`
	VcType               string                 `json:"vcType"`
	Required             []string               `json:"required"`
	Creator              string                 `json:"creator"`
	Properties           map[string]PropertyObj `json:"properties"`
	Created              string                 `json:"created"`
	AdditionalProperties bool                   `json:"additionalProperties"`
}

type PropertyObjPage struct {
	Type  string `json:"type"`
	Title string `json:"title"`
	Reg   string `json:"reg,omitempty,optional"`
	Desc  string `json:"desc,omitempty,optional"`
}

type VcTemplatePageRequest struct {
	Id       string `json:"id"`
	Name     string `json:"name"`
	Versions string `json:"versions"`
	Page     Page   `json:"page"`
}

type Page struct {
	Page  int32 `json:"page"`
	Size  int32 `json:"size"`
	Total int64 `json:"total,omitempty,optional"`
}

type VcTemplatePageResponse struct {
	Code int32                      `json:"code"`
	Msg  string                     `json:"msg"`
	Data VcTemplatePageResponseData `json:"data"`
}

type VcTemplatePageResponseData struct {
	Page Page               `json:"page"`
	List []VcTemplateDetail `json:"list"`
}

type VerifyResponse struct {
	Code int32  `json:"code"`
	Msg  string `json:"msg"`
}

type TrustIssuerAddRequest struct {
	Did []string `json:"did"`
}

type TrustIssuerAddResponse struct {
	Code int32  `json:"code"`
	Msg  string `json:"msg"`
}

type TrustIssuerFindListRequest struct {
	Page    Page   `json:"page"`
	Keyword string `json:"keyword"`
}

type TrustIssuerFindListResponse struct {
	Code int32                       `json:"code"`
	Msg  string                      `json:"msg"`
	Data TrustIssuerListResponseData `json:"data"`
}

type TrustIssuerListResponseData struct {
	Total int32    `json:"total"`
	List  []string `json:"list"`
}

type IssueLogCreateResponse struct {
	Code int32  `json:"code"`
	Msg  string `json:"msg"`
}

type IssueLogGetVcIssueLogsRequest struct {
	Page       Page   `json:"page"`
	Holder     string `json:"holder"`
	Issuer     string `json:"issuer"`
	TemplateId string `json:"templateId"`
}

type IssueLogGetVcIssueLogsResponseData struct {
	Total int32               `json:"total"`
	List  []VcIssueLogsDetail `json:"list"`
}

type VcIssueLogsDetail struct {
	Id         int32  `json:"id"`
	Holder     string `json:"holder"`
	Issuer     string `json:"issuer"`
	VcId       string `json:"vcId"`
	TemplateId string `json:"templateId"`
}

type IssueLogGetVcIssueLogsResponse struct {
	Code int32                              `json:"code"`
	Msg  string                             `json:"msg"`
	Data IssueLogGetVcIssueLogsResponseData `json:"data"`
}

type IssueLogGetVcIssuersRequest struct {
	Holder string `json:"holder"`
}

type IssueLogGetVcIssuersResponseData struct {
	Issuers []string `json:"issuers"`
}

type IssueLogGetVcIssuersResponse struct {
	Code int32                            `json:"code"`
	Msg  string                           `json:"msg"`
	Data IssueLogGetVcIssuersResponseData `json:"data"`
}

type CheckRequest struct {
	Did []string `json:"did"`
}

type CheckResponse struct {
	Code int32               `json:"code"`
	Msg  string              `json:"msg"`
	Data []CheckResponseData `json:"data"`
}

type CheckResponseData struct {
	Did   string `json:"did"`
	Exist bool   `json:"exist"`
}

type CheckListRequest struct {
	List []CheckListRequestData `json:"list"`
}

type CheckListRequestData struct {
	VcId   string `json:"vcId"`
	Issuer string `json:"issuer"`
}

type CheckListResponse struct {
	Code int32                   `json:"code"`
	Msg  string                  `json:"msg"`
	Data []CheckListResponseData `json:"data"`
}

type CheckListResponseData struct {
	VcId    string `json:"vcId"`
	Issuer  string `json:"issuer"`
	Revoked bool   `json:"revoked"`
}
