# DID数据同步服务

主要负责将主链A的DID数据同步到子链B。

## DID合约

主链DID合约在：
https://git.code.tencent.com/ChainMaker/opennet/contracts/contracts-go/tree/v1.2.0_qc/standard-did

子链DID同步合约在：https://git.code.tencent.com/ChainMaker/opennet/contracts/contracts-go/tree/v0.5.0_subchain/standard-did

请将以上两个合约安装到对应的ChainMaker链上。

## 服务的配置

1. 连接主链A：
[sdk_config_mainchain.yml](etc/sdk_config_mainchain.yml)
2. 连接子链B：
[sdk_config_subchain.yml](etc/sdk_config_subchain.yml)

3. 配置同步服务：[config.yaml](etc/config.yaml)
其中主要需要修改的是：

主链的合约名，监听的起始高度。

```
# 监听主链did合约信息
syncContract:
    name: "DID1"
    topic: #设置为空表示监听当前合约下的所有event
    endHeight: -1
    #如果起始高度设置为0,则使用数据库中记录的高度开始同步
    startHeight: 0
```

然后是子链同步的合约名：

```
subCmSdk:
  contractName: "subchain_did01"
```

其他配置项无需修改。
