// Copyright (C) BABEC. All rights reserved.
// Copyright (C) THL A29 Limited, a Tencent company. All rights reserved.
//
// SPDX-License-Identifier: Apache-2.0

package config

type IdeProxy struct {
	Path string `mapstructure:"path" json:"path" yaml:"path"` // 本地文件路径
	Port int    `mapstructure:"port" json:"port" yaml:"port"`
}

type CmSdk struct {
	MainChain       string      `mapstructure:"mainChain" json:"mainChain" yaml:"mainChain"` // 本服务的主链是什么链， 当前只有main/test
	ContractName    string      `mapstructure:"contractName" json:"contractName" yaml:"contractName"`
	ContractVersion string      `mapstructure:"contractVersion" json:"contractVersion" yaml:"contractVersion"`
	ChainConfig     ChainConfig `mapstructure:"chainConfig" json:"chainConfig" yaml:"chainConfig"`
}

type ChainConfig struct {
	SdkPath          string            `mapstructure:"sdkPath" json:"sdkPath" yaml:"sdkPath"`
	Admins           []Admin           `mapstructure:"admins" json:"admins" yaml:"admins"`
	ChainId          string            `mapstructure:"chainId" json:"chainId" yaml:"chainId"`
	IdentityContract *IdentityContract `mapstructure:"identityContract" json:"identityContract" yaml:"identityContract"`
}

type IdentityContract struct {
	Name     string `mapstructure:"name" json:"name" yaml:"name"`
	GasLimit uint64 `mapstructure:"gasLimit" json:"gasLimit" yaml:"gasLimit"`
	MaxCount uint64 `mapstructure:"maxCount" json:"maxCount" yaml:"maxCount"`
}

type Admin struct {
	Name string `mapstructure:"name" json:"name" yaml:"name"`
	Path string `mapstructure:"path" json:"path" yaml:"path"`
}

type SyncContract struct {
	Name        string   `mapstructure:"name" json:"name" yaml:"name"`
	Topic       []string `mapstructure:"topic" json:"topic" yaml:"topic"`
	EndHeight   int64    `mapstructure:"endHeight" json:"endHeight" yaml:"endHeight"`
	StartHeight int64    `mapstructure:"startHeight" json:"startHeight" yaml:"startHeight"`
}
