// Copyright (C) BABEC. All rights reserved.
// Copyright (C) THL A29 Limited, a Tencent company. All rights reserved.
//
// SPDX-License-Identifier: Apache-2.0

package handle

import (
	"context"
	"encoding/json"
	"fmt"
	"testing"

	"chainmaker.org/chainmaker/pb-go/v2/common"
	com "chainweaver.org.cn/chainweaver/did/did-sync/common"
	"chainweaver.org.cn/chainweaver/did/did-sync/core/listen"
	"chainweaver.org.cn/chainweaver/did/did-sync/global"
	"chainweaver.org.cn/chainweaver/did/did-sync/initialize"

	"github.com/stretchr/testify/require"
)

func TestSdk(t *testing.T) {
	global.GVA_VP = com.Viper("../../etc_test/config.yaml") // 初始化Viper
	global.LOG = initialize.Zap(global.CONFIG.Zap)

	client := initialize.InitSdk(global.CONFIG.MainCmSdk, false, global.LOG)

	height := uint64(46991)
	block, err := client.GetBlockByHeight(height, false)
	require.Nil(t, err)

	e := NewBlockHandler(nil, nil, nil)

	events, err := e.getValidEvents(block)
	require.Nil(t, err)

	fmt.Printf("events %+v\n", events)

	var eventList []*common.ContractEvent
	for _, list := range events {
		eventList = append(eventList, list...)
	}

	eventsByte, err := json.Marshal(eventList)
	if err != nil {
		require.Nil(t, err)
	}

	fmt.Printf("events string %s\n", eventsByte)
}

func TestBlockHandler(t *testing.T) {
	global.GVA_VP = com.Viper("../../etc_test/config.yaml") // 初始化Viper
	global.LOG = initialize.Zap(global.CONFIG.Zap)

	initialize.InitSdk(global.CONFIG.MainCmSdk, false, global.LOG)
	initialize.InitSdk(global.CONFIG.SubCmSdk, true, global.LOG)

	listener := listen.NewEventListener(int64(70120), -1, nil)
	handler := NewBlockHandler(listener.BlockChan, nil, nil)

	ctx := context.Background()

	err := listener.Start(ctx)
	if err != nil {
		require.Nil(t, err)
	}
	handler.Start(ctx)

	for {
		select {
		case event := <-handler.EventChan:
			eventInfo, err := json.Marshal(event)
			if err != nil {
				require.Nil(t, err)
			}
			fmt.Printf("Event %s\n", string(eventInfo))
		}
	}

}
