// Copyright (C) BABEC. All rights reserved.
// Copyright (C) THL A29 Limited, a Tencent company. All rights reserved.
//
// SPDX-License-Identifier: Apache-2.0

package listen

import (
	"context"
	"fmt"
	"time"

	"chainmaker.org/chainmaker/pb-go/v2/common"
	"chainweaver.org.cn/chainweaver/did/did-sync/global"
	"chainweaver.org.cn/chainweaver/did/did-sync/initialize"
)

// EventListener contract event listener
type EventListener struct {
	BlockChan  chan *common.BlockInfo
	startBlock int64
	endBlock   int64
	errorC     chan error
}

// NewEventListener new EventListener
func NewEventListener(startBlock, endBlock int64, errorC chan error) *EventListener {
	return &EventListener{
		BlockChan:  make(chan *common.BlockInfo, 10),
		startBlock: startBlock,
		endBlock:   endBlock,
		errorC:     errorC,
	}
}

// Start SubscribeBlock
func (e *EventListener) Start(ctx context.Context) error {
	//service start, subscribe block
	blockChan, err := initialize.MainSdkClient.SdkClient.SubscribeBlock(ctx, e.startBlock, e.endBlock, false, false)
	if err != nil {
		global.LOG.Error("start SubscribeBlock err: " + err.Error() + "sleep 30s...")
		//return err
	}
	go func() {
		for {
			var exit bool
			if blockChan != nil {
				exit = e.processBlockInfo(ctx, blockChan)
			}
			if exit {
				return
			}
			global.LOG.Error("processBlockInfo exit, sleep 30s...")
			time.Sleep(30 * time.Second)
			//re-subscribe
			blockChan, err = initialize.MainSdkClient.SdkClient.SubscribeBlock(ctx, e.startBlock, e.endBlock, false, false)
			if err != nil {
				global.LOG.Error("start SubscribeBlock err: " + err.Error())
			}
		}
	}()
	return nil
}

// Close event subscribe close
func (e *EventListener) Close(err error) {
	global.LOG.Error(err.Error())
}

func (e *EventListener) processBlockInfo(ctx context.Context, blockChan <-chan interface{}) (exit bool) {

	for {
		select {
		case block, ok := <-blockChan:
			if !ok {
				global.LOG.Error("chan is close!")
				return false
			}
			if block == nil {
				global.LOG.Error("block is nil")
				break
			}
			blockInfo, ok := block.(*common.BlockInfo)
			if !ok {
				global.LOG.Error("require block struct not is BlockInfo")
				e.errorC <- fmt.Errorf("require block struct not is BlockInfo")
				return false
			}

			// filter highly repetitive events
			if uint64(e.startBlock) < blockInfo.Block.Header.BlockHeight {
				e.startBlock = int64(blockInfo.Block.Header.BlockHeight)
			} else {
				break
			}

			e.BlockChan <- blockInfo

		case <-ctx.Done():
			return true
		}
	}
}
