// Copyright (C) BABEC. All rights reserved.
// Copyright (C) THL A29 Limited, a Tencent company. All rights reserved.
//
// SPDX-License-Identifier: Apache-2.0

package listen

import (
	"context"
	"encoding/json"
	"fmt"
	"strconv"
	"testing"

	"chainmaker.org/chainmaker/pb-go/v2/common"
	com "chainweaver.org.cn/chainweaver/did/did-sync/common"
	"chainweaver.org.cn/chainweaver/did/did-sync/config"
	"chainweaver.org.cn/chainweaver/did/did-sync/global"
	"chainweaver.org.cn/chainweaver/did/did-sync/initialize"

	"github.com/stretchr/testify/require"
)

func TestListen(t *testing.T) {
	global.GVA_VP = com.Viper("../../etc_test/config.yaml") // 初始化Viper
	global.LOG = initialize.Zap(global.CONFIG.Zap)

	initialize.InitSdk(global.CONFIG.MainCmSdk, false, global.LOG)

	listener := NewEventListener(int64(70120), -1, nil)
	ctx := context.Background()

	err := listener.Start(ctx)
	if err != nil {
		require.Nil(t, err)
	}

	for i := 0; i < 1; i++ {
		select {
		case block := <-listener.BlockChan:
			blockInfo, err := json.Marshal(block)
			if err != nil {
				require.Nil(t, err)
			}
			fmt.Printf("BlockInfo %s\n", string(blockInfo))
		}
	}
}

func TestUnitWithString(t *testing.T) {
	conf := config.CmSdk{
		ChainConfig: config.ChainConfig{
			SdkPath: "./testdata/sdk_config_pk_pubnet.yml",
			ChainId: initialize.MainChain,
		},
	}
	initialize.InitSdk(conf, false, nil)
	sconf := config.CmSdk{
		ChainConfig: config.ChainConfig{
			SdkPath: "./testdata/sdk_config.yml",
			ChainId: initialize.MainChain,
		},
	}

	initialize.InitSdk(sconf, true, nil)

	contractName := "did_sub"

	blockInfo, err := initialize.MainSdkClient.SdkClient.GetBlockByHeight(uint64(70000), false)
	require.NoError(t, err)

	str := strconv.FormatUint(blockInfo.Block.Header.BlockHeight, 10)
	setBlockHeightKv := []*common.KeyValuePair{
		{
			Key:   "blockHeight",
			Value: []byte(str),
		},
	}

	setBlockHeight := "SetBlockHeight"
	resp2, err := initialize.SubSdkClient.SdkClient.InvokeContract(contractName, setBlockHeight, "", setBlockHeightKv, -1, true)
	require.NoError(t, err)
	require.Equal(t, common.TxStatusCode_SUCCESS, resp2.Code)

	getBlockHeight := "GetBlockHeight"
	resp, err := initialize.SubSdkClient.SdkClient.QueryContract(contractName, getBlockHeight, nil, -1)
	require.NoError(t, err)
	require.Equal(t, common.TxStatusCode_SUCCESS, resp.Code)

	bytes := resp.ContractResult.Result
	height, err := strconv.ParseUint(string(bytes), 10, 64)

	expect := uint64(70000)
	require.Equal(t, expect, height)
}
