// Copyright (C) BABEC. All rights reserved.
// Copyright (C) THL A29 Limited, a Tencent company. All rights reserved.
//
// SPDX-License-Identifier: Apache-2.0

package sqlite

import (
	"chainweaver.org.cn/chainweaver/did/did-sync/global"
	"gorm.io/gorm"
)

type State struct {
	ChainType  string `gorm:"column:chain_type"`
	SyncHeight int64  `gorm:"column:sync_height"`
}

func (s *State) TableName() string {
	return "state"
}

func (s *State) InsertStatus() (*State, error) {
	err := global.GVA_DB.Table(s.TableName()).Create(s).Error
	return s, err
}

func GetState(chainType string) (*State, error) {
	var state State
	err := global.GVA_DB.Model(state).Where("chain_type", chainType).First(&state).Error

	return &state, err
}

func (s *State) UpdateChain(conn *gorm.DB) error {
	err := conn.Model(s).Updates(s).Error
	return err
}

func (s *State) UpdateStateHeight(chainType string, height uint64) error {
	return global.GVA_DB.Model(s).Where("chain_type = ?", chainType).Update("sync_height", height).Error
}

func DropState(conn *gorm.DB) error {
	return conn.Exec("DROP TABLE state").Error
}
