// Copyright (C) BABEC. All rights reserved.
// Copyright (C) THL A29 Limited, a Tencent company. All rights reserved.
//
// SPDX-License-Identifier: Apache-2.0

package initialize

import (
	"os"

	"chainweaver.org.cn/chainweaver/did/did-sync/db/sqlite"
	"chainweaver.org.cn/chainweaver/did/did-sync/global"

	"go.uber.org/zap"
	"gorm.io/gorm"
)

// Gorm 初始化数据库并产生数据库全局变量
func Gorm() *gorm.DB {
	switch global.CONFIG.System.DbType {
	case "sqlite":
		return StartSqliteConnect("")
	default:
		global.LOG.Error("sync service only support sqlite at this time !")
		return StartSqliteConnect("")
	}
}

// RegisterTables 注册数据库表专用
func RegisterTables(db *gorm.DB) {
	err := db.AutoMigrate(
		sqlite.State{},
	)
	if err != nil {
		global.LOG.Error("register table failed", zap.Error(err))
		os.Exit(0)
	}
	global.LOG.Info("register table success")
}
