// Copyright (C) BABEC. All rights reserved.
// Copyright (C) THL A29 Limited, a Tencent company. All rights reserved.
//
// SPDX-License-Identifier: Apache-2.0

package initialize

import (
	"context"
	"fmt"

	"chainweaver.org.cn/chainweaver/did/did-sync/config"
	"github.com/go-redis/redis/v8"
)

var (
	RedisClient = &redis.Client{}
)

func InitRedis(cfg *config.RedisConfig) *redis.Client {
	client := redis.NewClient(&redis.Options{
		Addr:     cfg.Addr,
		Password: cfg.Password,
		DB:       cfg.DB,
		Username: cfg.UserName,
	})
	_, err := client.Ping(context.Background()).Result()
	if err != nil {
		panic(fmt.Sprintf("InitRedis failed %s ", err.Error()))
	}

	RedisClient = client
	return client
}
