// Copyright (C) BABEC. All rights reserved.
// Copyright (C) THL A29 Limited, a Tencent company. All rights reserved.
//
// SPDX-License-Identifier: Apache-2.0

package initialize

import (
	sdk "chainmaker.org/chainmaker/sdk-go/v2"
	"chainweaver.org.cn/chainweaver/did/did-sync/config"

	"go.uber.org/zap"
)

var (
	MainSdkClient = &ClientSdk{}
	SubSdkClient  = &ClientSdk{}
)

type ClientSdk struct {
	SdkClient   *sdk.ChainClient
	ChainConfig config.ChainConfig
	Admin       []config.Admin
}

const (
	MainChain = "chainmaker_pk"
	TestChain = "chainmaker_testnet_pk"
)

func InitSdk(sdkConf config.CmSdk, sub bool, logger *zap.SugaredLogger) *sdk.ChainClient {
	var (
		sdkConfigPath string
		admin         []config.Admin

		client *sdk.ChainClient
		err    error

		clientSDk *ClientSdk
	)
	clientSDk = &ClientSdk{}

	sdkConfigPath = sdkConf.ChainConfig.SdkPath
	admin = sdkConf.ChainConfig.Admins

	if logger != nil {
		if sub {
			logger = logger.Named("[SubChain-SDK]")
		} else {
			logger = logger.Named("[MainChain-SDK]")
		}
		client, err = sdk.NewChainClient(
			sdk.WithConfPath(sdkConfigPath),
			sdk.WithChainClientLogger(logger),
		)
	} else {
		client, err = sdk.NewChainClient(
			sdk.WithConfPath(sdkConfigPath),
		)
	}

	if err != nil {
		panic(err)
	}

	clientSDk.Admin = admin
	clientSDk.SdkClient = client

	if sub {
		SubSdkClient = clientSDk
	} else {
		MainSdkClient = clientSDk
	}
	return client
}
