// Copyright (C) BABEC. All rights reserved.
// Copyright (C) THL A29 Limited, a Tencent company. All rights reserved.
//
// SPDX-License-Identifier: Apache-2.0

package initialize

import (
	"context"
	"fmt"
	"testing"

	"chainmaker.org/chainmaker/pb-go/v2/common"
	"chainweaver.org.cn/chainweaver/did/did-sync/config"
	"github.com/stretchr/testify/require"
)

func TestSdk(t *testing.T) {
	sconf := config.CmSdk{
		ChainConfig: config.ChainConfig{
			SdkPath: "../test/sdk_config_pk_pubnet.yml",
			ChainId: MainChain,
		},
	}
	client := InitSdk(sconf, false, nil)

	conf, err := client.GetChainConfig()
	require.Nil(t, err)

	fmt.Printf("chainConfig %+v\n", conf)

	chainInfo, err := client.GetChainInfo()
	require.Nil(t, err)

	fmt.Printf("chainInfo %+v\n", chainInfo)

	list, err := client.GetContractList()
	require.Nil(t, err)
	for _, name := range list {
		fmt.Printf("contractList %+v\n", name)
	}

}

func TestSendEvidenceTx(t *testing.T) {
	sconf := config.CmSdk{
		ChainConfig: config.ChainConfig{
			SdkPath: "../test/sdk_config_pk_pubnet.yml",
			ChainId: MainChain,
		},
	}
	client := InitSdk(sconf, false, nil)
	/*	config, err := client.GetChainConfig()
		require.Nil(t, err)*/

	kvs := []*common.KeyValuePair{
		{
			Key:   "id",
			Value: []byte("wx-org-001"),
		},
		{
			Key:   "hash",
			Value: []byte("520e086df734d00a40301a10934d127n"),
		},
		{
			Key: "metadata",
			Value: []byte(`"{"
	hashType ":"
	file ","
	hashAlgorithm ":"
	md5 ","
	username ":"
	taifu ","
	timestamp ":"
	1672048892 ","
	proveTimestamp ":"
	"}"`),
		},
	}

	payload := client.CreatePayload("", common.TxType_INVOKE_CONTRACT, "evidence", "Evidence", kvs, 0, &common.Limit{
		GasLimit: 90000000,
	})

	req, err := client.GenerateTxRequest(payload, nil)
	require.Nil(t, err)

	res, err := client.SendTxRequest(req, 0, true)
	require.Nil(t, err)

	fmt.Printf("Result is %+v", res)
}

func TestEvents(t *testing.T) {
	sconf := config.CmSdk{
		ChainConfig: config.ChainConfig{
			SdkPath: "../test/sdk_config_pk_pubnet.yml",
			ChainId: MainChain,
		},
	}
	client := InitSdk(sconf, false, nil)

	ctx := context.Background()
	eventChan, err := client.SubscribeContractEvent(ctx, int64(47000), int64(-1), "DID1", "")
	require.Nil(t, err)

	event, ok := <-eventChan
	if !ok {
		fmt.Println("chan is close!")
		return
	}

	contractEventInfo, ok := event.(*common.ContractEventInfo)
	if !ok {
		fmt.Println("the type pf event isn't *common.ContractEventInfo")
		return
	}

	fmt.Printf("contractEventInfo: %+v", contractEventInfo)

}
