// Copyright (C) BABEC. All rights reserved.
// Copyright (C) THL A29 Limited, a Tencent company. All rights reserved.
//
// SPDX-License-Identifier: Apache-2.0

/**
 * @Author: p_starxxliu
 * @Date: 2021/4/17 2:05 下午
 */

package initialize

import (
	"log"

	"gorm.io/driver/sqlite"
	"gorm.io/gorm"
)

var (
	sqlDB = &gorm.DB{}
)

func StartSqliteConnect(path string) *gorm.DB {
	if path == "" {
		path = "./sqlite.db"
	}

	db, err := gorm.Open(sqlite.Open(path), &gorm.Config{})
	if err != nil {
		log.Fatal("Sqlite db start err : " + err.Error())
	}

	sqlDB = db

	return db
}

func GetDB() *gorm.DB {
	return sqlDB
}

func Close() {
	sqlDB, err := sqlDB.DB()
	if err != nil {
		panic("close mysql db err: " + err.Error())
	}
	sqlDB.Close()
}
