/**
 * @Author: xueyanghan
 * @File: config.go
 * @Version: 1.0.0
 * @Description: desc.
 * @Date: 2023/8/16 18:27
 */

package config

import (
	"io/ioutil"

	"github.com/pkg/errors"
	"gopkg.in/yaml.v2"
)

const (
	defaultConfigPath = "/etc/mira-backend-service.yaml"
)

// InitConfig - chainweaver.org.cn/chainweaver/mira/mira-backend-service/ config init, load from yaml file
func InitConfig(path string) error {
	if path == "" {
		path = defaultConfigPath
	}

	yamlData, err := ioutil.ReadFile(path)
	if err != nil {
		return errors.Wrap(err, "read config file failed")
	}

	cfg := &Config{}

	err = yaml.Unmarshal(yamlData, cfg)
	if err != nil {
		return errors.Wrap(err, "unmarshal config file failed")
	}

	Conf = cfg
	return nil
}
