/**
 * @Author: xueyanghan
 * @File: types.go
 * @Version: 1.0.0
 * @Description: desc.
 * @Date: 2023/8/16 18:27
 */

package config

import "chainweaver.org.cn/chainweaver/mira/mira-common/config"

// Conf -
var Conf *Config

// Config - config
type Config struct {
	Common            CommonConfig        `yaml:"common"`
	Log               config.LogConfig    `yaml:"log"`
	Crypto            config.CryptoConfig `yaml:"crypto"`
	DB                config.DBConfig     `yaml:"database"`
	Mias              MIASClientConfig    `yaml:"mias_grpc"`
	MinioConfig       config.MinioConfig  `yaml:"minio"`
	KeyServiceConfig  KeyServiceConfig    `yaml:"key_service"`
	NetworkManagerUrl string              `yaml:"mira-network-manager-url"`
	JobServiceUrl     string              `yaml:"mira-job-service-url"`
	CrtBytes          []byte
	KeyBytes          []byte
}

// CommonConfig - common config
type CommonConfig struct {
	Port      int       `yaml:"port"`
	UrlPrefix string    `yaml:"url_prefix"`
	TLS       TLSConfig `yaml:"tls"`
}

// TLSConfig - tls config for grpc server
type TLSConfig struct {
	Enable  bool   `yaml:"enable"`
	CrtPath string `yaml:"crt_path"`
	KeyPath string `yaml:"key_path"`
	CaPath  string `yaml:"ca_path"`
}

type MIASClientConfig struct {
	Addr      string `yaml:"addr"`
	Enable    bool   `yaml:"enable"`
	CrtPath   string `yaml:"crt_path"`
	KeyPath   string `yaml:"key_path"`
	CaPath    string `yaml:"ca_path"`
	ServerDNS string `yaml:"server_dns"`
}

type KeyServiceConfig struct {
	KeyServiceDBName string `yaml:"key_service_db_name"`
}
