/**
 * @Author: xueyanghan
 * @File: get_asset_handler.go
 * @Version: 1.0.0
 * @Description: desc.
 * @Date: 2024/5/9 18:24
 */

package asset

import (
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/common"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/handler"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/service"
	"chainweaver.org.cn/chainweaver/mira/mira-common/logger"
	"github.com/gin-gonic/gin"
)

type GetAssetInfoHandler struct {
	req  GetAssetInfoReq
	resp common.Response
}

type GetAssetInfoReq struct {
	common.BaseRequest

	AssetId string `json:"assetId"  binding:"required"`
}

func (h *GetAssetInfoHandler) BindReq(c *gin.Context) error {
	if err := c.ShouldBindJSON(&h.req); err != nil {
		logger.Errorf("BindReq error: %v", err)
		h.resp.SetError(common.ErrCodeInvalidParameter, err.Error())
		return err
	}
	return nil
}

func (h *GetAssetInfoHandler) Process() {
	resp, err := service.MiraIdaAccessServiceImpl.GetAssetInfo(h.req.RequestId, h.req.ChainInfoId, h.req.AssetId)
	if err != nil {
		logger.Errorf("get asset list failed, err: %v", err)
		h.resp.SetError(common.ErrCodeGetAssetByIdFailed, err.Error())
		return
	}
	h.resp.SetData(resp)
}

func (h *GetAssetInfoHandler) GetResponse() *common.Response {
	return &h.resp
}

func GetAssetInfoHandleFunc(c *gin.Context) {
	handler.Run(&GetAssetInfoHandler{}, c)
	return
}
