package asset

import (
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/common"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/service"
	mira_common_config "chainweaver.org.cn/chainweaver/mira/mira-common/config"
	"chainweaver.org.cn/chainweaver/mira/mira-common/logger"
	"chainweaver.org.cn/chainweaver/mira/mira-common/types"
	"github.com/golang/mock/gomock"
	"net/http/httptest"
	"strings"
	"testing"

	"github.com/gin-gonic/gin"
	"github.com/stretchr/testify/assert"
)

var requestJSON = `{"assetId": "valid_asset_id", "ChainInfoId": 1}`

func init() {
	logConfig := mira_common_config.LogConfig{
		Level:    "Info",
		Module:   "mira-backend-service",
		FilePath: "../../../../cmd/logs/mira-backend-service.log",
	}
	logger.Init(&logConfig)
}

func NewGetAssetInfoHandler() *GetAssetInfoHandler {
	return &GetAssetInfoHandler{
		req:  GetAssetInfoReq{},
		resp: common.Response{},
	}
}

func TestGetAssetInfoReq_BindReq_ValidJSON(t *testing.T) {
	handler := NewGetAssetInfoHandler()
	// 准备 HTTP 请求上下文
	c, _ := gin.CreateTestContext(httptest.NewRecorder())

	// 准备请求 JSON

	// 绑定请求
	c.Request = httptest.NewRequest("POST", "/test", strings.NewReader(requestJSON))
	err := handler.BindReq(c)

	// 验证绑定是否成功
	assert.NoError(t, err)
	assert.Equal(t, "valid_asset_id", handler.req.AssetId)
}

func TestGetAssetInfoHandler_Process_ValidAssetID(t *testing.T) {
	// mock DB
	ctl := gomock.NewController(t)
	defer ctl.Finish()

	handler := NewGetAssetInfoHandler()
	c, _ := gin.CreateTestContext(httptest.NewRecorder())

	c.Request = httptest.NewRequest("POST", "/test", strings.NewReader(requestJSON))
	err := handler.BindReq(c)
	assert.NoError(t, err)
	mockMiraIdaAccessServiceImpl := service.NewMockMiraIdaAccessService(ctl)
	mockMiraIdaAccessServiceImpl.EXPECT().GetAssetInfo(gomock.Any(), gomock.Any(), gomock.Any()).
		Return(
			&types.AssetInfo{
				AssetId:   "1",
				AssetName: "test",
			},
			nil)
	service.MiraIdaAccessServiceImpl = mockMiraIdaAccessServiceImpl
	// 处理请求
	handler.Process()
	//handler.resp.Code
	// 验证响应是否包含错误
	assert.Equal(t, handler.resp.Code, common.ErrCodeOK)
	res := handler.GetResponse().Data.(*types.AssetInfo)
	assert.Equal(t, "test", res.AssetName)
}

//func TestGetAssetInfoHandler_Process_InvalidAssetID(t *testing.T) {
//	// 准备模拟服务，模拟返回错误
//	service.MiraIdaAccessService = &MockIdaAccess{}
//
//	// 准备处理程序
//	handler := asset.GetAssetInfoHandler{
//		req: asset.GetAssetInfoReq{
//			AssetId: "invalid_asset_id",
//		},
//		resp: asset.CommonResponse{},
//	}
//
//	// 处理请求
//	handler.Process()
//
//	// 验证响应是否包含错误
//	assert.False(t, handler.GetResponse().Success)
//	assert.Equal(t, "Asset not found", handler.GetResponse().Error)
//}
//
//// MockIdaAccess 用于模拟 service.MiraIdaAccessService 的接口
//type MockIdaAccess struct{}
//
//func (m *MockIdaAccess) GetAssetInfo(requestID, chainInfoID, assetID string) (interface{}, error) {
//	if assetID == "valid_asset_id" {
//		return map[string]interface{}{
//			"asset_name": "Valid Asset",
//			// 添加其他字段...
//		}, nil
//	}
//	return nil, errors.New("Asset not found")
//}
