/**
 * @Author: xueyanghan
 * @File: get_asset_list_handler.go
 * @Version: 1.0.0
 * @Description: desc.
 * @Date: 2024/5/9 15:45
 */

package asset

import (
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/common"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/handler"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/service"
	"chainweaver.org.cn/chainweaver/mira/mira-common/logger"
	"chainweaver.org.cn/chainweaver/mira/mira-common/types"
	"chainweaver.org.cn/chainweaver/mira/mira-common/types/comm"
	"github.com/gin-gonic/gin"
)

type GetAssetListHandler struct {
	req  GetAssetListReq
	resp common.Response
}

type GetAssetListReq struct {
	common.BaseRequest
	comm.ListInterfaceReq
}

func (h *GetAssetListHandler) BindReq(c *gin.Context) error {
	if err := c.ShouldBindJSON(&h.req); err != nil {
		logger.Errorf("BindReq error: %v", err)
		h.resp.SetError(common.ErrCodeInvalidParameter, err.Error())
		return err
	}
	h.req.ListInterfaceReq.DefaultIfNotSet()
	return nil
}

func (h *GetAssetListHandler) Process() {
	pagination, assetList, err := service.MiraIdaAccessServiceImpl.GetAssetList(h.req.RequestId, h.req.ChainInfoId, h.req.ListInterfaceReq)
	if err != nil {
		logger.Errorf("get asset list failed, err: %v", err)
		h.resp.SetError(common.ErrCodeGetAssetListFailed, err.Error())
		return
	}

	resp := &comm.ListInterfaceResp[types.AssetItem]{
		Pagination: *pagination,
		List:       assetList,
	}
	h.resp.SetData(resp)
}

func (h *GetAssetListHandler) GetResponse() *common.Response {
	return &h.resp
}

func GetAssetListHandleFunc(c *gin.Context) {
	handler.Run(&GetAssetListHandler{}, c)
	return
}
