/**
 * @Author: xueyanghan
 * @File: get_asset_handler.go
 * @Version: 1.0.0
 * @Description: desc.
 * @Date: 2024/5/9 18:24
 */

package asset

import (
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/common"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/handler"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/service"
	"chainweaver.org.cn/chainweaver/mira/mira-common/logger"
	"github.com/gin-gonic/gin"
)

type GetEnterpriseListHandler struct {
	req  GetEnterpriseListReq
	resp common.Response
}

type GetEnterpriseListReq struct {
	common.BaseRequest

	AssetName string `json:"assetName"`
}

func (h *GetEnterpriseListHandler) BindReq(c *gin.Context) error {
	if err := c.ShouldBindJSON(&h.req); err != nil {
		logger.Errorf("BindReq error: %v", err)
		h.resp.SetError(common.ErrCodeInvalidParameter, err.Error())
		return err
	}
	return nil
}

func (h *GetEnterpriseListHandler) Process() {
	resp, err := service.MiraIdaAccessServiceImpl.GetEnterpriseList(h.req.RequestId, h.req.ChainInfoId, h.req.AssetName)
	if err != nil {
		logger.Errorf("get asset list failed, err: %v", err)
		h.resp.SetError(common.ErrCodeGetAssetByIdFailed, err.Error())
		return
	}
	h.resp.SetData(resp)
}

func (h *GetEnterpriseListHandler) GetResponse() *common.Response {
	return &h.resp
}

func GetEnterpriseListHandlerFunc(c *gin.Context) {
	handler.Run(&GetEnterpriseListHandler{}, c)
	return
}
