package computingResource

import (
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/common"
	"chainweaver.org.cn/chainweaver/mira/mira-backend-service/core/ctrl/handler"
	"chainweaver.org.cn/chainweaver/mira/mira-common/dbaccess"
	"chainweaver.org.cn/chainweaver/mira/mira-common/logger"
	"chainweaver.org.cn/chainweaver/mira/mira-common/types"
	"chainweaver.org.cn/chainweaver/mira/mira-common/types/state"
	"github.com/gin-gonic/gin"
)

type GetComputingResourceGroupDetailHandler struct {
	req  GetComputingResourceGroupDetailReq
	resp common.Response
}

type GetComputingResourceGroupDetailReq struct {
	common.BaseRequest
	GroupId string `json:"groupId" binding:"required"`
}

type GetComputingResourceGroupDetailResp struct {
	types.ComputingResourceGroup
}

func (h *GetComputingResourceGroupDetailHandler) BindReq(c *gin.Context) error {
	if err := c.ShouldBindJSON(&h.req); err != nil {
		logger.Errorf("BindReq error: %v", err)
		h.resp.SetError(common.ErrCodeInvalidParameter, err.Error())
		return err
	}
	return nil
}

func (h *GetComputingResourceGroupDetailHandler) Process() {
	query := make(map[string]interface{})
	query["chain_info_id = ?"] = h.req.ChainInfoId
	query["group_id = ?"] = h.req.GroupId
	query["status = ?"] = state.ComputingResourceStatus_PUBLISHED

	value, err := dbaccess.DBAccessService.GetComputingResourceGroupDetail(query)
	if err != nil {
		logger.Errorf("get computing resource group detail failed, err: %v", err)
		h.resp.SetError(common.ErrCodeDataComputingResourceChainFailed, err.Error())
		return
	}
	h.resp.SetData(value)
}

func (h *GetComputingResourceGroupDetailHandler) GetResponse() *common.Response {
	return &h.resp
}

func GetComputingResourceGroupDetailHandleFunc(c *gin.Context) {
	handler.Run(&GetComputingResourceGroupDetailHandler{}, c)
	return
}
